/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ListMultimap<class_2960, class_2960> getStructureIDsToConfiguredStructureIDs(class_3218 world) {
        ArrayListMultimap structureKeysToConfiguredStructureKeys = ArrayListMultimap.create();
        for (class_5312 configuredStructure : StructureUtils.getConfiguredStructureRegistry(world)) {
            structureKeysToConfiguredStructureKeys.put((Object)StructureUtils.getIDForStructure(world, configuredStructure.field_24835), (Object)StructureUtils.getIDForConfiguredStructure(world, configuredStructure));
        }
        return structureKeysToConfiguredStructureKeys;
    }

    public static Map<class_2960, class_2960> getConfiguredStructureIDsToStructureIDs(class_3218 world) {
        HashMap<class_2960, class_2960> configuredStructureKeysToStructureKeys = new HashMap<class_2960, class_2960>();
        for (class_5312 configuredStructure : StructureUtils.getConfiguredStructureRegistry(world)) {
            configuredStructureKeysToStructureKeys.put(StructureUtils.getIDForConfiguredStructure(world, configuredStructure), StructureUtils.getIDForStructure(world, configuredStructure.field_24835));
        }
        return configuredStructureKeysToStructureKeys;
    }

    public static class_2378<class_5312<?, ?>> getConfiguredStructureRegistry(class_3218 world) {
        return world.method_30349().method_30530(class_2378.field_25915);
    }

    public static class_2960 getIDForConfiguredStructure(class_3218 world, class_5312<?, ?> configuredStructure) {
        return StructureUtils.getConfiguredStructureRegistry(world).method_10221(configuredStructure);
    }

    public static class_5312<?, ?> getConfiguredStructureForID(class_3218 world, class_2960 id) {
        return (class_5312)StructureUtils.getConfiguredStructureRegistry(world).method_10223(id);
    }

    public static class_2960 getIDForStructure(class_3218 world, class_3195<?> structure) {
        return class_6625.method_38713((class_3218)world).comp_134().method_30530(class_2378.field_25077).method_10221(structure);
    }

    public static List<class_2960> getAllowedConfiguredStructureIDs(class_3218 world) {
        ArrayList<class_2960> configuredStructureIDs = new ArrayList<class_2960>();
        for (class_5312 configuredStructure : StructureUtils.getConfiguredStructureRegistry(world)) {
            if (configuredStructure == null || StructureUtils.getIDForConfiguredStructure(world, configuredStructure) == null || StructureUtils.getIDForConfiguredStructure(world, configuredStructure).method_12836().isEmpty() || StructureUtils.getIDForConfiguredStructure(world, configuredStructure).method_12832().isEmpty() || StructureUtils.structureIsBlacklisted(world, configuredStructure)) continue;
            configuredStructureIDs.add(StructureUtils.getIDForConfiguredStructure(world, configuredStructure));
        }
        return configuredStructureIDs;
    }

    public static class_6880<class_5312<?, ?>> getEntryForStructure(class_3218 world, class_5312<?, ?> structure) {
        Optional optional = StructureUtils.getConfiguredStructureRegistry(world).method_29113(structure);
        if (optional.isPresent()) {
            return (class_6880)StructureUtils.getConfiguredStructureRegistry(world).method_40264((class_5321)optional.get()).get();
        }
        return null;
    }

    public static boolean structureIsBlacklisted(class_3218 world, class_5312<?, ?> structure) {
        List<String> structureBlacklist = ExplorersCompassConfig.structureBlacklist;
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getIDForConfiguredStructure(world, structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    public static List<class_2960> getGeneratingDimensionIDs(class_3218 serverWorld, class_5312<?, ?> structure) {
        ArrayList<class_2960> dimensions = new ArrayList<class_2960>();
        for (class_3218 world : serverWorld.method_8503().method_3738()) {
            class_2794 chunkGenerator = world.method_14178().method_12129();
            Set biomeSet = chunkGenerator.method_12098().method_28443();
            if (structure.method_40549().method_40239().noneMatch(biomeSet::contains)) continue;
            dimensions.add(world.method_27983().method_29177());
        }
        if (structure.field_24835 == class_3195.field_24852 && dimensions.isEmpty()) {
            dimensions.add(new class_2960("minecraft:overworld"));
        }
        return dimensions;
    }

    public static ListMultimap<class_2960, class_2960> getGeneratingDimensionIDsForAllowedConfiguredStructures(class_3218 serverWorld) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (class_2960 id : StructureUtils.getAllowedConfiguredStructureIDs(serverWorld)) {
            class_5312<?, ?> configuredStructure = StructureUtils.getConfiguredStructureForID(serverWorld, id);
            dimensionsForAllowedStructures.putAll((Object)id, StructureUtils.getGeneratingDimensionIDs(serverWorld, configuredStructure));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getHorizontalDistanceToLocation(class_1657 player, int x, int z) {
        return StructureUtils.getHorizontalDistanceToLocation(player.method_24515(), x, z);
    }

    public static int getHorizontalDistanceToLocation(class_2338 startPos, int x, int z) {
        return (int)class_3532.method_15355((float)((float)startPos.method_10262((class_2382)new class_2338(x, startPos.method_10264(), z))));
    }

    @Environment(value=EnvType.CLIENT)
    public static String getStructureName(class_2960 id) {
        if (id == null) {
            return "";
        }
        String name = id.toString();
        if (ExplorersCompassConfig.translateStructureNames) {
            name = class_1074.method_4662((String)class_156.method_646((String)"structure", (class_2960)id), (Object[])new Object[0]);
        }
        if (name.equals(class_156.method_646((String)"structure", (class_2960)id)) || !ExplorersCompassConfig.translateStructureNames) {
            name = id.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @Environment(value=EnvType.CLIENT)
    public static String getStructureSource(class_2960 id) {
        if (id == null) {
            return "";
        }
        String registryEntry = id.toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = FabricLoader.getInstance().getModContainer(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getMetadata().getName();
        }
        return modid;
    }

    @Environment(value=EnvType.CLIENT)
    public static String structureDimensionsToString(List<class_2960> dimensions) {
        Object str = "";
        if (dimensions != null && dimensions.size() > 0) {
            str = StructureUtils.getDimensionName(dimensions.get(0));
            for (int i = 1; i < dimensions.size(); ++i) {
                str = (String)str + ", " + StructureUtils.getDimensionName(dimensions.get(i));
            }
        }
        return str;
    }

    @Environment(value=EnvType.CLIENT)
    private static String getDimensionName(class_2960 dimensionKey) {
        String name = class_1074.method_4662((String)class_156.method_646((String)"dimension", (class_2960)dimensionKey), (Object[])new Object[0]);
        if (name.equals(class_156.method_646((String)"dimension", (class_2960)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

