/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.smwyg.mixin;

import io.github.apace100.smwyg.duck.ItemSharingTextFieldWidget;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin
implements ItemSharingTextFieldWidget {
    @Shadow
    private String field_2092;
    private class_1799 itemStack;
    private String insertedString;
    private int insertedLength;
    private int insertedIndex = 0;

    @Override
    public void setStack(class_1799 stack) {
        this.itemStack = stack;
        class_2561 text = stack.method_7954();
        this.insertedString = text.getString();
        this.insertedLength = this.insertedString.length();
    }

    @Override
    public class_1799 getStack() {
        return this.itemStack;
    }

    @Override
    public String getTextBefore() {
        return this.field_2092.substring(0, this.insertedIndex);
    }

    @Override
    public String getTextAfter() {
        return this.field_2092.substring(this.insertedIndex + this.insertedLength);
    }

    @Override
    public boolean hasStack() {
        return this.itemStack != null;
    }

    @Override
    public void onSuggestionInserted(int start, int offset) {
        if (this.itemStack != null && start <= this.insertedIndex) {
            this.insertedIndex += offset;
        }
    }

    @Inject(method={"getCursorPosWithOffset"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCursorOffset(int offset, CallbackInfoReturnable<Integer> cir) {
        int original = (Integer)cir.getReturnValue();
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (offset < 0) {
                cir.setReturnValue((Object)this.insertedIndex);
            } else {
                cir.setReturnValue((Object)(this.insertedIndex + this.insertedLength));
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setSelectionStart(I)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void moveInsertedText(String text, CallbackInfo ci, int i, int j, int k, String string, int l, String string2) {
        if (i <= this.insertedIndex && j <= this.insertedIndex) {
            this.insertedIndex += l;
        }
    }

    @ModifyVariable(method={"setCursor"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifyCursorSetting(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (original <= this.insertedIndex + this.insertedLength / 2) {
                return this.insertedIndex;
            }
            return this.insertedIndex + this.insertedLength;
        }
        return original;
    }

    @ModifyVariable(method={"setSelectionStart"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionStart(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex;
        }
        return original;
    }

    @Inject(method={"eraseCharacters"}, at={@At(value="INVOKE", target="Ljava/lang/StringBuilder;<init>(Ljava/lang/String;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void eraseInsertion(int characterOffset, CallbackInfo ci, int i, int j, int k) {
        boolean isEndInside;
        boolean isStartInside = j > this.insertedIndex && j < this.insertedIndex + this.insertedLength;
        boolean bl = isEndInside = k > this.insertedIndex && k < this.insertedIndex + this.insertedLength;
        if (isStartInside || isEndInside || j < this.insertedIndex && k >= this.insertedIndex + this.insertedLength) {
            this.itemStack = null;
            this.insertedLength = 0;
            this.insertedString = "";
            this.insertedIndex = 0;
        } else if (j <= this.insertedIndex || k <= this.insertedIndex) {
            this.insertedIndex -= k - j;
        }
    }

    @ModifyVariable(method={"setSelectionEnd"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionEnd(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex;
        }
        return original;
    }
}

