/*
 * Decompiled with CFR 0.152.
 */
package com.github.reoseah.catwalksinc.block;

import com.github.reoseah.catwalksinc.CIncBlocks;
import com.github.reoseah.catwalksinc.CIncItems;
import com.github.reoseah.catwalksinc.CatwalksInc;
import com.github.reoseah.catwalksinc.block.CatwalkAccess;
import com.github.reoseah.catwalksinc.block.CatwalkBlock;
import com.github.reoseah.catwalksinc.block.PaintScrapableBlock;
import com.github.reoseah.catwalksinc.block.Paintable;
import com.github.reoseah.catwalksinc.block.WaterloggableBlock;
import com.github.reoseah.catwalksinc.block.Wrenchable;
import com.github.reoseah.catwalksinc.block.entity.CatwalkStairsBlockEntity;
import com.github.reoseah.catwalksinc.block.state.ElementMode;
import com.github.reoseah.catwalksinc.block.state.Side;
import com.github.reoseah.catwalksinc.block.util.WrenchHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CatwalkStairsBlock
extends WaterloggableBlock
implements class_2343,
CatwalkAccess,
Wrenchable,
Paintable {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 RIGHT_RAIL = class_2746.method_11825((String)"right");
    public static final class_2746 LEFT_RAIL = class_2746.method_11825((String)"left");
    private static final class_265[][] OUTLINE_SHAPES = new class_265[4][4];
    private static final class_265[][] COLLISION_SHAPES = new class_265[4][4];

    public CatwalkStairsBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)RIGHT_RAIL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LEFT_RAIL, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, HALF, RIGHT_RAIL, LEFT_RAIL});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int i = ((Boolean)state.method_11654((class_2769)LEFT_RAIL) != false ? 1 : 0) | ((Boolean)state.method_11654((class_2769)RIGHT_RAIL) != false ? 2 : 0);
        class_265 voxelShape = OUTLINE_SHAPES[((class_2350)state.method_11654(FACING)).method_10161()][i];
        return state.method_11654(HALF) == class_2756.field_12609 ? voxelShape.method_1096(0.0, -1.0, 0.0) : voxelShape;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int i = ((Boolean)state.method_11654((class_2769)LEFT_RAIL) != false ? 1 : 0) | ((Boolean)state.method_11654((class_2769)RIGHT_RAIL) != false ? 2 : 0);
        class_265 voxelShape = COLLISION_SHAPES[((class_2350)state.method_11654(FACING)).method_10161()][i];
        return state.method_11654(HALF) == class_2756.field_12609 ? voxelShape.method_1096(0.0, -1.0, 0.0) : voxelShape;
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        int i = ((Boolean)state.method_11654((class_2769)LEFT_RAIL) != false ? 1 : 0) | ((Boolean)state.method_11654((class_2769)RIGHT_RAIL) != false ? 2 : 0);
        class_265 voxelShape = OUTLINE_SHAPES[((class_2350)state.method_11654(FACING)).method_10161()][i];
        return state.method_11654(HALF) == class_2756.field_12609 ? voxelShape.method_1096(0.0, -1.0, 0.0) : voxelShape;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)super.method_9605(ctx).method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8652(pos.method_10084(), (class_2680)((class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos.method_10084()).method_15772() == class_3612.field_15910)), 3);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            if (player.method_7337()) {
                CatwalkStairsBlock.onBreakInCreative(world, pos, state, player);
            } else {
                CatwalkStairsBlock.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, (class_2586)null, (class_1297)player, (class_1799)player.method_6047());
            }
        }
        super.method_9576(world, pos, state, player);
    }

    protected static void onBreakInCreative(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 below;
        class_2680 stateBelow;
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (half == class_2756.field_12609 && (stateBelow = world.method_8320(below = pos.method_10074())).method_26204() == state.method_26204() && stateBelow.method_11654(HALF) == class_2756.field_12607) {
            world.method_8652(below, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, below, class_2248.method_9507((class_2680)stateBelow));
        }
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), blockEntity, stack);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        class_2756 half = (class_2756)(state = super.method_9559(state, direction, newState, world, posFrom, pos)).method_11654(HALF);
        if (!(half != class_2756.field_12607 || direction != class_2350.field_11036 || newState.method_26204() instanceof CatwalkStairsBlock && newState.method_11654(HALF) == class_2756.field_12609)) {
            return class_2246.field_10124.method_9564();
        }
        if (!(half != class_2756.field_12609 || direction != class_2350.field_11033 || newState.method_26204() instanceof CatwalkStairsBlock && newState.method_11654(HALF) == class_2756.field_12607)) {
            return class_2246.field_10124.method_9564();
        }
        class_2350 left = ((class_2350)state.method_11654(FACING)).method_10170();
        state = (class_2680)state.method_11657((class_2769)LEFT_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail(state, world, pos, left, Side.LEFT)));
        class_2350 right = ((class_2350)state.method_11654(FACING)).method_10160();
        state = (class_2680)state.method_11657((class_2769)RIGHT_RAIL, (Comparable)Boolean.valueOf(this.shouldHaveHandrail(state, world, pos, right, Side.RIGHT)));
        return state;
    }

    public boolean shouldHaveHandrail(class_2680 state, class_1936 world, class_2338 pos, class_2350 direction, Side side) {
        CatwalkStairsBlockEntity catwalk;
        Optional<ElementMode> handrail;
        class_2586 be;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
            state = (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12607);
        }
        if ((be = world.method_8321(pos)) instanceof CatwalkStairsBlockEntity && (handrail = (catwalk = (CatwalkStairsBlockEntity)be).getHandrailState(side)).isPresent()) {
            return handrail.get() == ElementMode.ALWAYS;
        }
        class_2680 neighbor = world.method_8320(pos.method_10093(direction));
        class_2680 above = world.method_8320(pos.method_10093(direction).method_10084());
        if (neighbor.method_26206((class_1922)world, pos.method_10093(direction), direction.method_10153()) && neighbor.method_26207() != class_3614.field_15916 && above.method_26206((class_1922)world, pos.method_10093(direction).method_10084(), direction.method_10153()) && above.method_26207() != class_3614.field_15916) {
            return false;
        }
        if (neighbor.method_26204() instanceof CatwalkStairsBlock) {
            CatwalkStairsBlockEntity catwalkbe;
            if (neighbor.method_11654(FACING) != state.method_11654(FACING) || neighbor.method_11654(HALF) != state.method_11654(HALF)) {
                return true;
            }
            class_2586 otherbe = world.method_8321(pos.method_10093(direction));
            return otherbe instanceof CatwalkStairsBlockEntity && (catwalkbe = (CatwalkStairsBlockEntity)otherbe).isHandrailForced(side.getOpposite());
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_9522(class_2680 state, class_2680 state2, class_2350 direction) {
        return direction.method_10166().method_10179() && state2.method_26204() == this && state.method_11654(FACING) == direction && state2.method_11654(FACING) == direction.method_10153() && state.method_11654(HALF) == class_2756.field_12607 || super.method_9522(state, state2, direction);
    }

    @Override
    public boolean needsCatwalkAccess(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            return side == state.method_11654(FACING);
        }
        return side == ((class_2350)state.method_11654(FACING)).method_10153();
    }

    @Override
    public boolean needsCatwalkConnectivity(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
        return this.needsCatwalkAccess(state, world, pos, side);
    }

    @Override
    public boolean useWrench(class_2680 state, class_1937 world, class_2338 pos, class_2350 side, class_1657 player, class_1268 hand, class_243 hitPos) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
            state = world.method_8320(pos);
        }
        if (player != null && player.method_5715()) {
            world.method_8501(pos, (class_2680)state.method_28493(FACING));
            world.method_8501(pos.method_10084(), (class_2680)((class_2680)state.method_28493(FACING)).method_11657(HALF, (Comparable)class_2756.field_12609));
            return true;
        }
        CatwalkStairsBlockEntity be = (CatwalkStairsBlockEntity)world.method_8321(pos);
        if (be == null) {
            be = new CatwalkStairsBlockEntity(pos, state);
            world.method_8438((class_2586)be);
        }
        Side stairsSide = WrenchHelper.getBlockHalf(pos, hitPos, (class_2350)state.method_11654(FACING));
        class_2680 newState = be.useWrench(stairsSide, state, player);
        world.method_8501(pos, newState);
        world.method_8501(pos.method_10084(), (class_2680)newState.method_11657(HALF, (Comparable)class_2756.field_12609));
        if (be.canBeRemoved()) {
            world.method_8544(pos);
        }
        return true;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!(newState.method_26204() instanceof CatwalkStairsBlock)) {
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)CIncItems.CATWALK);
    }

    @Override
    public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
        class_2248 block = PaintedCatwalkStairsBlock.ofColor(color);
        return block != null;
    }

    @Override
    public void paintBlock(class_1767 color, class_2680 state, class_1936 world, class_2338 pos) {
        class_2248 block = PaintedCatwalkStairsBlock.ofColor(color);
        if (block != null) {
            class_2680 colored = (class_2680)((class_2680)((class_2680)((class_2680)block.method_9564().method_11657(FACING, (Comparable)((class_2350)state.method_11654(FACING)))).method_11657((class_2769)RIGHT_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)RIGHT_RAIL)))).method_11657((class_2769)LEFT_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)LEFT_RAIL)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
            class_2338 lower = CatwalkStairsBlock.getLowerHalfPos(state, pos);
            world.method_8652(lower, (class_2680)colored.method_11657(HALF, (Comparable)class_2756.field_12607), 3);
            world.method_8652(lower.method_10084(), (class_2680)colored.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        }
    }

    protected static class_2338 getLowerHalfPos(class_2680 state, class_2338 pos) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return pos.method_10074();
        }
        return pos;
    }

    public static class_2746 getHandrailProperty(Side side) {
        return side == Side.LEFT ? LEFT_RAIL : RIGHT_RAIL;
    }

    public static class_2350 getSideDirection(class_2350 facing, Side side) {
        return side == Side.LEFT ? facing.method_10160() : facing.method_10170();
    }

    static {
        class_265[] floors = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)9.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0, (double)8.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)9.0, (double)16.0), (class_265)class_2248.method_9541((double)8.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)8.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)8.0, (double)16.0, (double)17.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)8.0, (double)17.0, (double)16.0))};
        class_265[] leftRails = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)2.0, (double)32.0, (double)8.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)24.0, (double)2.0), (class_265)class_2248.method_9541((double)8.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)2.0)), class_259.method_1084((class_265)class_2248.method_9541((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)24.0, (double)8.0), (class_265)class_2248.method_9541((double)14.0, (double)16.0, (double)8.0, (double)16.0, (double)32.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)8.0, (double)14.0, (double)16.0, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)14.0, (double)8.0, (double)32.0, (double)16.0))};
        class_265[] rightRails = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)14.0, (double)8.0, (double)8.0, (double)16.0, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)14.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)8.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)14.0, (double)8.0, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)8.0, (double)16.0, (double)14.0, (double)16.0, (double)32.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)24.0, (double)8.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)8.0, (double)2.0, (double)32.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)24.0, (double)2.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)8.0, (double)32.0, (double)2.0))};
        class_265[] leftRailsColl = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)0.5, (double)8.0, (double)8.0, (double)1.0, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)0.5, (double)16.0, (double)0.0, (double)1.0, (double)32.0, (double)8.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.5, (double)8.0, (double)24.0, (double)1.0), (class_265)class_2248.method_9541((double)8.0, (double)16.0, (double)0.5, (double)16.0, (double)32.0, (double)1.0)), class_259.method_1084((class_265)class_2248.method_9541((double)15.0, (double)8.0, (double)0.0, (double)15.5, (double)24.0, (double)8.0), (class_265)class_2248.method_9541((double)15.0, (double)16.0, (double)8.0, (double)15.5, (double)32.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)8.0, (double)15.0, (double)16.0, (double)24.0, (double)15.5), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)15.0, (double)8.0, (double)32.0, (double)15.5))};
        class_265[] rightRailsColl = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)15.0, (double)8.0, (double)8.0, (double)15.5, (double)24.0, (double)16.0), (class_265)class_2248.method_9541((double)15.0, (double)16.0, (double)0.0, (double)15.5, (double)32.0, (double)8.0)), class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)15.0, (double)8.0, (double)24.0, (double)15.5), (class_265)class_2248.method_9541((double)8.0, (double)16.0, (double)15.0, (double)16.0, (double)32.0, (double)15.5)), class_259.method_1084((class_265)class_2248.method_9541((double)0.5, (double)8.0, (double)0.0, (double)1.0, (double)24.0, (double)8.0), (class_265)class_2248.method_9541((double)0.5, (double)16.0, (double)8.0, (double)1.0, (double)32.0, (double)16.0)), class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)8.0, (double)0.5, (double)16.0, (double)24.0, (double)1.0), (class_265)class_2248.method_9541((double)0.0, (double)16.0, (double)0.5, (double)8.0, (double)32.0, (double)1.0))};
        for (int i = 0; i < 4; ++i) {
            class_265 class_2652 = floors[i];
            CatwalkStairsBlock.OUTLINE_SHAPES[i][0] = class_2652;
            CatwalkStairsBlock.COLLISION_SHAPES[i][0] = class_2652;
            CatwalkStairsBlock.OUTLINE_SHAPES[i][1] = class_259.method_1084((class_265)floors[i], (class_265)leftRails[i]);
            CatwalkStairsBlock.OUTLINE_SHAPES[i][2] = class_259.method_1084((class_265)floors[i], (class_265)rightRails[i]);
            CatwalkStairsBlock.OUTLINE_SHAPES[i][3] = class_259.method_17786((class_265)floors[i], (class_265[])new class_265[]{leftRails[i], rightRails[i]});
            CatwalkStairsBlock.COLLISION_SHAPES[i][1] = class_259.method_1084((class_265)floors[i], (class_265)leftRailsColl[i]);
            CatwalkStairsBlock.COLLISION_SHAPES[i][2] = class_259.method_1084((class_265)floors[i], (class_265)rightRailsColl[i]);
            CatwalkStairsBlock.COLLISION_SHAPES[i][3] = class_259.method_17786((class_265)floors[i], (class_265[])new class_265[]{leftRailsColl[i], rightRailsColl[i]});
        }
    }

    public static class PaintedCatwalkStairsBlock
    extends CatwalkStairsBlock
    implements PaintScrapableBlock {
        protected static final Map<class_1767, class_2248> INSTANCES = new EnumMap<class_1767, class_2248>(class_1767.class);
        protected final class_1767 color;

        public PaintedCatwalkStairsBlock(class_1767 color, class_4970.class_2251 settings) {
            super(settings);
            this.color = color;
            INSTANCES.put(color, this);
        }

        public static class_2248 ofColor(class_1767 color) {
            return INSTANCES.get(color);
        }

        public String method_9539() {
            return class_156.method_646((String)"misc", (class_2960)CatwalksInc.id("painted_catwalk_stairs"));
        }

        public void method_9568(class_1799 stack, class_1922 world, List<class_2561> tooltip, class_1836 options) {
            super.method_9568(stack, world, tooltip, options);
            tooltip.add((class_2561)new class_2588("misc.catwalksinc." + this.color.method_15434()).method_27692(class_124.field_1080));
        }

        @Override
        public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
            return new class_1799((class_1935)CatwalkBlock.PaintedCatwalkBlock.ofColor(this.color));
        }

        @Override
        public boolean canPaintBlock(class_1767 color, class_2680 state, class_1922 world, class_2338 pos) {
            return false;
        }

        @Override
        public void scrapPaint(class_2680 state, class_1936 world, class_2338 pos) {
            class_2680 uncolored = (class_2680)((class_2680)((class_2680)((class_2680)CIncBlocks.CATWALK_STAIRS.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)RIGHT_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)RIGHT_RAIL)))).method_11657((class_2769)LEFT_RAIL, (Comparable)((Boolean)state.method_11654((class_2769)LEFT_RAIL)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
            class_2338 lower = PaintedCatwalkStairsBlock.getLowerHalfPos(state, pos);
            world.method_8652(lower, (class_2680)uncolored.method_11657((class_2769)HALF, (Comparable)class_2756.field_12607), 3);
            world.method_8652(lower.method_10084(), (class_2680)uncolored.method_11657((class_2769)HALF, (Comparable)class_2756.field_12609), 3);
        }
    }
}

