/*
 * Decompiled with CFR 0.152.
 */
package us.spaceclouds42.disableportals;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Main main = new Main();

    public static Config loadConfig(File configFile) {
        Config config;
        block18: {
            if (configFile.exists() && configFile.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(configFile);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (Config)GSON.fromJson((Reader)bufferedReader, Config.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("[DP] Problem occurred when trying to load config: ", e);
                }
            }
            config = new Config();
        }
        config.saveConfig(configFile);
        return config;
    }

    public void saveConfig(File configFile) {
        try (FileOutputStream stream = new FileOutputStream(configFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.out.println("[DP] Problem occurred when saving config: " + e.getMessage());
        }
    }

    public static class Main {
        public boolean disableNetherPortals = false;
        public boolean disableEndPortals = false;
        public boolean disableEndGateways = false;
    }
}

