/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import net.dark_roleplay.gdarp.CommonClass;

public class PackConfig {
    private static boolean hasLoadedConfig = false;
    private static Optional<List<String>> REQUIRED_DATAPACKS;
    private static Optional<List<String>> OPTIONAL_DATAPACKS;
    private static Optional<List<String>> REQUIRED_RESOURCEACKS;

    public static void loadConfigs() {
        if (hasLoadedConfig) {
            return;
        }
        try {
            Files.createDirectories(new File(CommonClass.getGameDir().toFile(), "/config/").toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(CommonClass.getGameDir().toFile(), "/config/global_data_and_resourcepacks.toml")).defaultData(PackConfig.class.getClassLoader().getResource("default_config.toml")).build();
        config.load();
        REQUIRED_DATAPACKS = config.getOptional("datapacks.required");
        OPTIONAL_DATAPACKS = config.getOptional("datapacks.optional");
        REQUIRED_RESOURCEACKS = config.getOptional("resourcepacks.required");
        config.close();
        hasLoadedConfig = true;
    }

    public static Optional<List<String>> getRequiredDatapacks() {
        PackConfig.loadConfigs();
        return REQUIRED_DATAPACKS;
    }

    public static Optional<List<String>> getOptionalDatapacks() {
        PackConfig.loadConfigs();
        return OPTIONAL_DATAPACKS;
    }

    public static Optional<List<String>> getRequiredResourceacks() {
        PackConfig.loadConfigs();
        return REQUIRED_RESOURCEACKS;
    }
}

