/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp.pack_finders;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public class MultiFilePackFinder
implements class_3285 {
    private static final FileFilter RESOURCEPACK_FILTER = pack -> {
        if (pack.isFile() && pack.getName().endsWith(".zip")) {
            try {
                FileSystem pfs = FileSystems.newFileSystem(pack.toPath());
                Path pth = pfs.getPath("assets/", new String[0]);
                return Files.exists(pth, new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return pack.isDirectory() && new File(pack, "pack.mcmeta").isFile() && new File(pack, "assets/").exists();
    };
    private static final FileFilter DATAPACK_FILTER = pack -> {
        if (pack.isFile() && pack.getName().endsWith(".zip")) {
            try {
                FileSystem pfs = FileSystems.newFileSystem(pack.toPath());
                Path pth = pfs.getPath("data/", new String[0]);
                return Files.exists(pth, new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return pack.isDirectory() && new File(pack, "pack.mcmeta").isFile() && new File(pack, "data/").exists();
    };
    private final boolean shouldForcePacks;
    private final Map<File, FilePackType> packs;
    private final class_5352 packSource;
    private final class_3264 packType;

    public MultiFilePackFinder(boolean shouldForcePacks, class_3264 packType, class_5352 packSource, Set<File> files) {
        this.shouldForcePacks = shouldForcePacks;
        this.packSource = packSource;
        this.packs = new HashMap<File, FilePackType>();
        this.packType = packType;
        for (File file : files) {
            this.packs.put(file, FilePackType.MISSING);
        }
    }

    private void updatePacks() {
        for (File file : this.packs.keySet()) {
            if (file.isFile() && file.getPath().endsWith(".zip")) {
                this.packs.put(file, FilePackType.ZIPED_PACK);
                continue;
            }
            if (file.isDirectory() && new File(file, "pack.mcmeta").exists()) {
                this.packs.put(file, FilePackType.UNZIPED_PACK);
                continue;
            }
            try {
                if (Files.notExists(file.toPath(), new LinkOption[0])) {
                    Files.createDirectories(file.toPath(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.packs.put(file, FilePackType.PACK_FOLDER);
        }
    }

    public void method_14453(Consumer<class_3288> packConsumer, class_3288.class_5351 packBuilder) {
        this.updatePacks();
        block4: for (File file : this.packs.keySet()) {
            FilePackType type = this.packs.get(file);
            class_3288 pack = null;
            switch (type) {
                case UNZIPED_PACK: 
                case ZIPED_PACK: {
                    pack = class_3288.method_14456((String)(this.shouldForcePacks ? "global:" : "globalOpt:" + file.getName()), (boolean)this.shouldForcePacks, this.createSupplier(file), (class_3288.class_5351)packBuilder, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)this.packSource);
                    if (pack == null) break;
                    packConsumer.accept(pack);
                    break;
                }
                case PACK_FOLDER: {
                    File[] afile = file.listFiles(this.packType == class_3264.field_14190 ? DATAPACK_FILTER : RESOURCEPACK_FILTER);
                    if (afile == null) break;
                    File[] fileArray = afile;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File packFile;
                        pack = class_3288.method_14456((String)((this.shouldForcePacks ? "global:" : "globalOpt:") + (packFile = fileArray[i]).getName()), (boolean)this.shouldForcePacks, this.createSupplier(packFile), (class_3288.class_5351)packBuilder, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)this.packSource);
                        if (pack == null) continue;
                        packConsumer.accept(pack);
                        pack = null;
                    }
                    continue block4;
                }
            }
        }
    }

    private Supplier<class_3262> createSupplier(File pack) {
        return pack.isDirectory() ? () -> new class_3259(pack) : () -> new class_3258(pack);
    }

    private static enum FilePackType {
        MISSING,
        ZIPED_PACK,
        UNZIPED_PACK,
        PACK_FOLDER;

    }
}

