/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.creeperhost.ftbbackups.FTBBackups;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.data.Backup;
import net.creeperhost.ftbbackups.data.Backups;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.Region;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.RegionFolder;
import net.creeperhost.ftbbackups.utils.FileUtils;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BackupHandler {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Path serverRoot;
    private static Path backupFolderPath;
    private static Path worldFolder;
    public static final AtomicBoolean backupRunning;
    private static final AtomicBoolean backupFailed;
    private static AtomicReference<String> backupPreview;
    public static boolean isDirty;
    public static AtomicReference<Backups> backups;
    private static String failReason;
    private static long lastAutoBackup;
    public static CompletableFuture<Void> currentFuture;
    public static Path defaultBackupLocation;

    public static void init(MinecraftServer minecraftServer) {
        block7: {
            FTBBackups.serverSaveEvent(minecraftServer.method_30002());
            serverRoot = minecraftServer.method_3831().toPath().normalize().toAbsolutePath();
            defaultBackupLocation = serverRoot.resolve("backups");
            if (!Config.cached().backup_location.equalsIgnoreCase(".")) {
                try {
                    Path configPath = Path.of(Config.cached().backup_location, new String[0]);
                    if (Files.exists(configPath, new LinkOption[0])) {
                        FTBBackups.LOGGER.info("Using configured backups directory at {}", (Object)configPath.toAbsolutePath());
                        backupFolderPath = configPath;
                        break block7;
                    }
                    FTBBackups.LOGGER.error(configPath.toAbsolutePath() + " does not exist, please create the directory before continuing");
                    backupFolderPath = defaultBackupLocation;
                }
                catch (Exception e) {
                    FTBBackups.LOGGER.error("Unable to find backup folder from config {} using default {}", (Object)Config.cached().backup_location, (Object)defaultBackupLocation.toAbsolutePath());
                    e.printStackTrace();
                    backupFolderPath = defaultBackupLocation;
                }
            } else {
                backupFolderPath = defaultBackupLocation;
            }
        }
        BackupHandler.createBackupFolder(defaultBackupLocation);
        BackupHandler.createBackupFolder(backupFolderPath);
        BackupHandler.loadJson();
        FTBBackups.LOGGER.info("Starting backup cleaning thread");
        if (FTBBackups.backupExecutor == null || FTBBackups.backupExecutor.isShutdown()) {
            FTBBackups.backupExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("FTB Backups backup thread %d").setDaemon(true).build());
        }
        if (FTBBackups.backupCleanerWatcherExecutorService.isShutdown()) {
            FTBBackups.backupCleanerWatcherExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("FTB Backups scheduled executor %d").build());
        }
        FTBBackups.backupCleanerWatcherExecutorService.scheduleAtFixedRate(BackupHandler::clean, 0L, 30L, TimeUnit.SECONDS);
    }

    public static String createPreview(MinecraftServer minecraftServer) {
        try {
            MinecraftDimension dim = MinecraftDimension.OVERWORLD;
            RenderSettings settings = new RenderSettings();
            RegionRenderer renderer = new RegionRenderer(settings);
            Path worldPath = minecraftServer.method_27050(class_5218.field_24188).toAbsolutePath();
            Path dimPath = worldPath.resolve(dim.getRegionPath());
            Path previewPath = worldPath.resolve("backupPreview");
            RegionFolder.WorldRegionFolder w = RegionFolder.WorldRegionFolder.load(dimPath, renderer, false);
            RegionFolder.CachedRegionFolder r = RegionFolder.CachedRegionFolder.create(w, false, previewPath);
            try {
                Files.walk(previewPath, new FileVisitOption[0]).forEach(f -> {
                    try {
                        Files.deleteIfExists(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                Files.deleteIfExists(previewPath);
                Files.createDirectories(previewPath, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector2ic lastPos = null;
            long lastTimestamp = 0L;
            for (Vector2ic p : w.listRegions()) {
                try {
                    long thisTimestamp = w.getTimestamp(p);
                    if (thisTimestamp <= lastTimestamp) continue;
                    lastPos = p;
                    lastTimestamp = thisTimestamp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (lastPos != null) {
                Region render = r.render(lastPos);
                ImageIO.write((RenderedImage)render.getImage(), "png", baos);
            }
            byte[] image = baos.toByteArray();
            try {
                Files.walk(previewPath, new FileVisitOption[0]).forEach(f -> {
                    try {
                        Files.deleteIfExists(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                Files.deleteIfExists(previewPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            baos.close();
            return "data:image/png;base64, " + Base64.getEncoder().encodeToString(image);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static boolean isRunning() {
        return backupRunning.get();
    }

    public static void createBackup(MinecraftServer minecraftServer) {
        BackupHandler.createBackup(minecraftServer, false, "automated");
    }

    public static void createBackup(MinecraftServer minecraftServer, boolean protect, String name) {
        try {
            if (minecraftServer == null) {
                return;
            }
            if (minecraftServer.method_30002() == null) {
                return;
            }
            if (FTBBackups.isShutdown) {
                return;
            }
            if (Config.cached().only_if_players_been_online && !isDirty) {
                FTBBackups.LOGGER.info("Skipping backup, no players have been online since last backup.");
                return;
            }
            worldFolder = minecraftServer.method_27050(class_5218.field_24188).toAbsolutePath();
            FTBBackups.LOGGER.info("Found world folder at " + worldFolder);
            Calendar calendar = Calendar.getInstance();
            String date = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
            String time = calendar.get(11) + "-" + calendar.get(12) + "-" + calendar.get(13);
            String backupName = date + "_" + time + ".zip";
            Path backupLocation = backupFolderPath.resolve(backupName);
            if (BackupHandler.canCreateBackup()) {
                lastAutoBackup = System.currentTimeMillis();
                if (backupRunning == null) {
                    return;
                }
                backupRunning.set(true);
                minecraftServer.method_20493(() -> {
                    if (minecraftServer == null) {
                        return;
                    }
                    if (minecraftServer.method_3760() == null) {
                        return;
                    }
                    if (minecraftServer.method_3760().method_14574() == 0) {
                        return;
                    }
                    minecraftServer.method_3760().method_14617();
                });
                minecraftServer.method_5385(() -> minecraftServer.method_3723(true, true, true));
                BackupHandler.setNoSave(minecraftServer, true);
                AtomicLong startTime = new AtomicLong(System.nanoTime());
                AtomicLong finishTime = new AtomicLong();
                currentFuture = CompletableFuture.runAsync(() -> {
                    try {
                        BackupHandler.alertPlayers(minecraftServer, (class_2561)new class_2588("ftbbackups2.backup.starting"));
                        Path backupPath = backupFolderPath.resolve(backupName);
                        LinkedList<Path> backupPaths = new LinkedList<Path>();
                        backupPaths.add(worldFolder);
                        for (String p : Config.cached().additional_directories) {
                            try {
                                Path path = serverRoot.resolve(p);
                                if (!FileUtils.isChildOf(path, serverRoot)) {
                                    FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a child of the server root directory.", (Object)p);
                                    continue;
                                }
                                if (path.equals(worldFolder)) {
                                    FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is the world folder.", (Object)p);
                                    continue;
                                }
                                if (FileUtils.isChildOf(path, worldFolder)) {
                                    FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the world folder.", (Object)p);
                                    continue;
                                }
                                if (FileUtils.isChildOf(path, backupFolderPath)) {
                                    FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the backups folder.", (Object)p);
                                    continue;
                                }
                                if (!Files.isDirectory(path, new LinkOption[0])) {
                                    FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a directory..", (Object)p);
                                    continue;
                                }
                                if (!Files.exists(path, new LinkOption[0])) continue;
                                backupPaths.add(path);
                            }
                            catch (Exception err) {
                                FTBBackups.LOGGER.error("Failed to add additional directory '{}' to the backup.", (Object)p, (Object)err);
                            }
                        }
                        backupPreview.set(BackupHandler.createPreview(minecraftServer));
                        FileUtils.pack(backupPath, serverRoot, backupPaths);
                        backupFailed.set(false);
                        isDirty = false;
                    }
                    catch (Exception e) {
                        backupRunning.set(false);
                        backupFailed.set(true);
                        BackupHandler.alertPlayers(minecraftServer, (class_2561)new class_2588("ftbbackups2.backup.failed"));
                        FTBBackups.LOGGER.error("Failed to create backup");
                        isDirty = false;
                        e.printStackTrace();
                    }
                }, FTBBackups.backupExecutor).thenRun(() -> {
                    currentFuture = null;
                    if (backupFailed.get()) {
                        backupFailed.set(false);
                        backupRunning.set(false);
                        return;
                    }
                    finishTime.set(System.nanoTime());
                    long elapsedTime = finishTime.get() - startTime.get();
                    backupRunning.set(false);
                    BackupHandler.setNoSave(minecraftServer, false);
                    BackupHandler.alertPlayers(minecraftServer, (class_2561)new class_2585("Backup finished in " + BackupHandler.format(elapsedTime) + (String)(Config.cached().display_file_size ? " Size: " + FileUtils.getSizeString(backupLocation.toFile().length()) : "")));
                    String sha1 = FileUtils.getSha1(backupLocation);
                    float ratio = (float)backupLocation.toFile().length() / (float)FileUtils.getFolderSize(worldFolder.toFile());
                    FTBBackups.LOGGER.info("Backup size " + FileUtils.getSizeString(backupLocation.toFile().length()) + " World Size " + FileUtils.getSizeString(FileUtils.getFolderSize(worldFolder.toFile())));
                    Backup backup = new Backup(worldFolder.normalize().getFileName().toString(), System.currentTimeMillis(), backupLocation.toString(), FileUtils.getSize(backupLocation.toFile()), ratio, sha1, backupPreview.get(), protect, name);
                    BackupHandler.addBackup(backup);
                    BackupHandler.updateJson();
                    FTBBackups.LOGGER.info("New backup created at " + backupLocation + " size: " + FileUtils.getSizeString(backupLocation) + " Took: " + BackupHandler.format(elapsedTime) + " Sha1: " + sha1);
                });
            } else {
                if (!failReason.isEmpty()) {
                    backupRunning.set(false);
                    Object failMessage = "Unable to create backup, Reason: " + failReason;
                    BackupHandler.alertPlayers(minecraftServer, (class_2561)new class_2588((String)failMessage));
                    FTBBackups.LOGGER.error((String)failMessage);
                    failMessage = "";
                }
                backupRunning.set(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            backupRunning.set(false);
        }
    }

    public static void addBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            backups1.add(backup);
            return backups1;
        });
    }

    public static void removeBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            if (backups1.contains(backup)) {
                backups1.remove(backup);
                return backups1;
            }
            return backups1;
        });
    }

    @Nullable
    public static Backup getLatestBackup() {
        if (backups == null) {
            return null;
        }
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentNewest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (currentNewest == null) {
                currentNewest = backup;
            }
            if (backup.getCreateTime() <= currentNewest.getCreateTime()) continue;
            currentNewest = backup;
        }
        return currentNewest;
    }

    @Nullable
    public static Backup getOldestBackup() {
        if (backups == null) {
            return null;
        }
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentOldest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (backup.isProtected()) continue;
            if (currentOldest == null) {
                currentOldest = backup;
            }
            if (backup.getCreateTime() >= currentOldest.getCreateTime()) continue;
            currentOldest = backup;
        }
        return currentOldest;
    }

    public static void clean() {
        try {
            if (FTBBackups.isShutdown) {
                return;
            }
            if (backupRunning.get()) {
                return;
            }
            if (backups.get().unprotectedSize() > Config.cached().max_backups) {
                FTBBackups.LOGGER.info("More backups than " + Config.cached().max_backups + " found, Removing oldest backup");
                int backupsNeedRemoving = backups.get().unprotectedSize() - Config.cached().max_backups;
                if (backupsNeedRemoving > 0 && BackupHandler.getOldestBackup() != null) {
                    for (int i = 0; i < backupsNeedRemoving; ++i) {
                        Path backupFile = Path.of(BackupHandler.getOldestBackup().getBackupLocation(), new String[0]);
                        if (!Files.exists(backupFile, new LinkOption[0])) continue;
                        boolean removed = Files.deleteIfExists(backupFile);
                        String log = removed ? "Removed old backup " + backupFile.getFileName() : " Failed to remove backup " + backupFile.getFileName();
                        FTBBackups.LOGGER.info(log);
                    }
                    BackupHandler.verifyOldBackups();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadJson() {
        Path json = defaultBackupLocation.resolve("backups.json");
        if (Files.exists(json, new LinkOption[0])) {
            Gson gson = new Gson();
            try {
                FileReader fileReader = new FileReader(json.toFile());
                backups.getAndUpdate(backups1 -> (Backups)gson.fromJson((Reader)fileReader, Backups.class));
                fileReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateJson() {
        try {
            String jsonString = "[]";
            if (!backups.get().isEmpty()) {
                jsonString = GSON.toJson((Object)backups.get(), Backups.class);
            }
            BackupHandler.writeToFile(jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(String json) {
        FTBBackups.LOGGER.info("Writing to file " + defaultBackupLocation.resolve("backups.json"));
        try (FileOutputStream fileOutputStream = new FileOutputStream(defaultBackupLocation.resolve("backups.json").toFile());){
            IOUtils.write((String)json, (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean canCreateBackup() {
        if (backupFolderPath == null) {
            failReason = "backup folder path is null";
            return false;
        }
        if (!backupFolderPath.toFile().exists()) {
            failReason = "backup folder does not exist";
            return false;
        }
        if (backupRunning.get()) {
            FTBBackups.LOGGER.info("Unable to start new backup as backup is already running");
            failReason = "Unable to start new backup as backup is already running";
            return false;
        }
        if (lastAutoBackup != 0L && Config.cached().manual_backups_time != 0 && System.currentTimeMillis() < lastAutoBackup + 60000L) {
            failReason = "Manuel backup was recently taken";
            return false;
        }
        if (currentFuture != null) {
            failReason = "backup thread is somehow still running";
            FTBBackups.LOGGER.error("currentFuture is not null??");
            return false;
        }
        long free = backupFolderPath.toFile().getFreeSpace();
        long currentWorldSize = FileUtils.getFolderSize(worldFolder.toFile());
        for (String p : Config.cached().additional_directories) {
            try {
                Path path = worldFolder.getParent().resolve(p);
                if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) continue;
                currentWorldSize += FileUtils.getFolderSize(path.toFile());
            }
            catch (Exception path) {}
        }
        if (BackupHandler.getLatestBackup() == null) {
            FTBBackups.LOGGER.info("Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current free space: " + FileUtils.getSizeString(free));
            if (currentWorldSize > free) {
                failReason = "not enough free space on device";
                return false;
            }
        } else {
            long latestBackupSize = BackupHandler.getLatestBackup().getSize();
            float ratio = BackupHandler.getLatestBackup().getRatio();
            long expectedSize = (long)((int)(Math.ceil((float)currentWorldSize * ratio) / 100.0)) * 105L;
            FTBBackups.LOGGER.info("Last backup size: " + FileUtils.getSizeString(latestBackupSize) + " Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current free space: " + FileUtils.getSizeString(free) + " ExpectedSize " + FileUtils.getSizeString(expectedSize));
            if (expectedSize > free) {
                failReason = "not enough free space on device";
                return false;
            }
        }
        return true;
    }

    public static void verifyOldBackups() {
        if (backups == null) {
            return;
        }
        if (backups.get().isEmpty()) {
            return;
        }
        ArrayList<Backup> backupsCopy = new ArrayList<Backup>(backups.get().getBackups());
        for (Backup backup : backupsCopy) {
            FTBBackups.LOGGER.debug("Verifying backup " + backup.getBackupLocation());
            if (Files.exists(Path.of(backup.getBackupLocation(), new String[0]), new LinkOption[0])) continue;
            BackupHandler.removeBackup(backup);
            FTBBackups.LOGGER.info("File missing, removing from backups " + backup.getBackupLocation());
        }
        BackupHandler.updateJson();
    }

    public static void createBackupFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            boolean backupFolderCreated = path.toFile().mkdirs();
            String log = backupFolderCreated ? "Created backup folder at " + path.toAbsolutePath() : "Failed to create backup folder at " + path.toAbsolutePath();
            FTBBackups.LOGGER.info(log);
        }
    }

    public static void setNoSave(MinecraftServer minecraftServer, boolean value) {
        if (minecraftServer == null) {
            return;
        }
        try {
            if (minecraftServer.method_3738() != null) {
                for (class_3218 level : minecraftServer.method_3738()) {
                    if (level == null) continue;
                    FTBBackups.LOGGER.info("Setting world " + level.method_27983().method_29177() + " save state to " + value);
                    level.field_13957 = value;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void alertPlayers(MinecraftServer minecraftServer, class_2561 message) {
        if (Config.cached().do_not_notify) {
            return;
        }
        if (Config.cached().notify_op_only && minecraftServer instanceof class_3176) {
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                if (!player.method_5687(4)) continue;
                player.method_9203(message, class_156.field_25140);
            }
        } else {
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                player.method_9203(message, class_156.field_25140);
            }
        }
    }

    public static String format(long nano) {
        Duration duration = Duration.ofNanos(nano);
        long mins = duration.toMinutes();
        long seconds = duration.minusMinutes(mins).toSeconds();
        long mili = duration.minusSeconds(seconds).toMillis();
        return mins + "m, " + seconds + "s, " + mili + "ms";
    }

    static {
        backupRunning = new AtomicBoolean(false);
        backupFailed = new AtomicBoolean(false);
        backupPreview = new AtomicReference<String>("");
        isDirty = false;
        backups = new AtomicReference<Backups>(new Backups());
        failReason = "";
        lastAutoBackup = 0L;
    }
}

