/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import net.creeperhost.ftbbackups.BackupHandler;
import net.creeperhost.ftbbackups.config.Config;
import net.minecraft.class_1132;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.server.MinecraftServer;

public class BackupCommand {
    public static long lastManualBackupTime = 0L;
    public static final SuggestionProvider<class_2168> SUGGESTIONS = (commandContext, suggestionsBuilder) -> {
        String[] strings = new String[]{"start", "snapshot"};
        return class_2172.method_9253((String[])strings, (SuggestionsBuilder)suggestionsBuilder);
    };

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backup").requires(cs -> cs.method_9259(BackupCommand.hasPerm(cs.method_9211())))).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTIONS).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(cs -> BackupCommand.execute((CommandContext<class_2168>)cs, StringArgumentType.getString((CommandContext)cs, (String)"command"), StringArgumentType.getString((CommandContext)cs, (String)"name")))))).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTIONS).executes(cs -> BackupCommand.execute((CommandContext<class_2168>)cs, StringArgumentType.getString((CommandContext)cs, (String)"command"), "")));
    }

    public static int hasPerm(MinecraftServer server) {
        class_1132 integratedServer;
        if (server.method_3816() || server instanceof class_1132 && (integratedServer = (class_1132)server).method_3860()) {
            return Config.cached().command_permission_level;
        }
        return 0;
    }

    private static int execute(CommandContext<class_2168> cs, String command, String name) {
        boolean isProtected = false;
        switch (command.toLowerCase(Locale.ROOT)) {
            case "snapshot": {
                isProtected = true;
            }
        }
        if (Config.cached().manual_backups_time == 0) {
            BackupHandler.isDirty = true;
            BackupHandler.createBackup(((class_2168)cs.getSource()).method_9211(), isProtected, name);
        } else {
            long configTimeFromMinutes = (long)Config.cached().manual_backups_time * 60000L;
            long lastBackupWithConfig = lastManualBackupTime + configTimeFromMinutes;
            if (System.currentTimeMillis() > lastBackupWithConfig) {
                lastManualBackupTime = System.currentTimeMillis();
                BackupHandler.createBackup(((class_2168)cs.getSource()).method_9211(), isProtected, name);
            } else {
                ((class_2168)cs.getSource()).method_9213((class_2561)new class_2588("Unable to create backup, Last backup was taken less than " + Config.cached().max_backups + " Minutes ago"));
            }
        }
        return 0;
    }
}

