/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.org.quartz.jobs;

import java.io.File;
import java.io.FileFilter;
import net.creeperhost.ftbbackups.org.quartz.DisallowConcurrentExecution;
import net.creeperhost.ftbbackups.org.quartz.Job;
import net.creeperhost.ftbbackups.org.quartz.JobDataMap;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionContext;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionException;
import net.creeperhost.ftbbackups.org.quartz.PersistJobDataAfterExecution;
import net.creeperhost.ftbbackups.org.quartz.SchedulerContext;
import net.creeperhost.ftbbackups.org.quartz.SchedulerException;
import net.creeperhost.ftbbackups.org.quartz.jobs.DirectoryScanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class DirectoryScanJob
implements Job {
    public static final String DIRECTORY_NAME = "DIRECTORY_NAME";
    public static final String DIRECTORY_SCAN_LISTENER_NAME = "DIRECTORY_SCAN_LISTENER_NAME";
    public static final String MINIMUM_UPDATE_AGE = "MINIMUM_UPDATE_AGE";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        long maxAgeDate;
        File[] updatedFiles;
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        SchedulerContext schedCtxt = null;
        try {
            schedCtxt = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Error obtaining scheduler context.", e, false);
        }
        String dirName = mergedJobDataMap.getString(DIRECTORY_NAME);
        String listenerName = mergedJobDataMap.getString(DIRECTORY_SCAN_LISTENER_NAME);
        if (dirName == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_NAME' not found in merged JobDataMap");
        }
        if (listenerName == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_SCAN_LISTENER_NAME' not found in merged JobDataMap");
        }
        DirectoryScanListener listener = (DirectoryScanListener)schedCtxt.get(listenerName);
        if (listener == null) {
            throw new JobExecutionException("DirectoryScanListener named '" + listenerName + "' not found in SchedulerContext");
        }
        long lastDate = -1L;
        if (mergedJobDataMap.containsKey(LAST_MODIFIED_TIME)) {
            lastDate = mergedJobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        long minAge = 5000L;
        if (mergedJobDataMap.containsKey(MINIMUM_UPDATE_AGE)) {
            minAge = mergedJobDataMap.getLong(MINIMUM_UPDATE_AGE);
        }
        if ((updatedFiles = this.getUpdatedOrNewFiles(dirName, lastDate, maxAgeDate = System.currentTimeMillis() + minAge)) == null) {
            this.log.warn("Directory '" + dirName + "' does not exist.");
            return;
        }
        long latestMod = 0L;
        for (File updFile : updatedFiles) {
            long lm = updFile.lastModified();
            latestMod = lm > latestMod ? lm : latestMod;
        }
        if (updatedFiles.length > 0) {
            this.log.info("Directory '" + dirName + "' contents updated, notifying listener.");
            listener.filesUpdatedOrAdded(updatedFiles);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Directory '" + dirName + "' contents unchanged.");
        }
        context.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, latestMod);
    }

    protected File[] getUpdatedOrNewFiles(String dirName, final long lastDate, final long maxAgeDate) {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.lastModified() > lastDate && pathname.lastModified() < maxAgeDate;
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }
}

