/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.cit.builtin.conditions;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.ex.CITParsingException;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public abstract class ListCondition<T extends CITCondition>
extends CITCondition {
    public static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\p{Zs}+");
    private final Class<T> conditionType;
    protected final Type listType;
    protected final Pattern delimiter;
    protected final Supplier<T> conditionSupplier;
    protected T[] conditions;

    protected ListCondition(Class<T> conditionType, Type listType, Pattern delimiter, Supplier<T> conditionSupplier) {
        this.conditionType = conditionType;
        this.listType = listType;
        this.delimiter = delimiter;
        this.conditionSupplier = conditionSupplier;
    }

    protected ListCondition(Class<T> conditionType, Supplier<T> conditionSupplier) {
        this(conditionType, Type.OR, PATTERN_WHITESPACE, conditionSupplier);
    }

    @Override
    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        ArrayList<CITCondition> conditions = new ArrayList<CITCondition>();
        for (String conditionValue : this.delimiter.split(value.value())) {
            CITCondition condition = (CITCondition)this.conditionSupplier.get();
            condition.load(new PropertyValue(value.keyMetadata(), conditionValue, value.separator(), value.position(), value.propertiesIdentifier(), value.packName()), properties);
            conditions.add(condition);
        }
        this.conditions = conditions.toArray((CITCondition[])Array.newInstance(this.conditionType, 0));
    }

    @Override
    public boolean test(CITContext context) {
        return this.listType.test((CITCondition[])this.conditions, context);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        OR{

            @Override
            public boolean test(CITCondition[] conditions, CITContext context) {
                for (CITCondition condition : conditions) {
                    if (!condition.test(context)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        AND{

            @Override
            public boolean test(CITCondition[] conditions, CITContext context) {
                for (CITCondition condition : conditions) {
                    if (condition.test(context)) continue;
                    return false;
                }
                return true;
            }
        };


        public abstract boolean test(CITCondition[] var1, CITContext var2);
    }
}

