/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.block;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PBlockEntityTypes;
import agency.highlysuspect.packages.block.PBlocks;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.junk.ILoveMojang;
import agency.highlysuspect.packages.junk.PTags;
import agency.highlysuspect.packages.junk.PackageContainer;
import agency.highlysuspect.packages.junk.PackageStyle;
import agency.highlysuspect.packages.junk.TwelveDirection;
import agency.highlysuspect.packages.net.PackageAction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class PackageBlockEntity
extends class_2586
implements class_1263,
class_1275 {
    private PackageStyle style = PackageStyle.ERROR_LOL;
    private final PackageContainer container = new PackageContainer().addListener(c -> this.method_5431());
    private class_1799 stickyStack = class_1799.field_8037;
    private class_2561 customName;

    public PackageBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)PBlockEntityTypes.PACKAGE.get(), pos, state);
    }

    public PackageStyle getStyle() {
        return this.style;
    }

    public void setStyle(PackageStyle style) {
        this.style = style;
    }

    public PackageContainer getContainer() {
        return this.container;
    }

    public boolean canBeSticky() {
        if (this.field_11863 == null) {
            return false;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!this.field_11863.method_8320(this.method_11016().method_10093(dir)).method_26164(PTags.STICKY)) continue;
            return true;
        }
        return false;
    }

    public boolean isSticky() {
        return this.canBeSticky() && !this.stickyStack.method_7960();
    }

    public void updateStickyStack() {
        boolean anythingChanged = this.updateStickyStack0();
        if (anythingChanged) {
            this.method_5431();
        }
    }

    private boolean updateStickyStack0() {
        if (!this.canBeSticky()) {
            this.stickyStack = class_1799.field_8037;
            return true;
        }
        if (this.stickyStack.method_7960() || !this.stickyStack.method_7960() && !this.container.method_5442()) {
            this.stickyStack = this.container.getFilterStack().method_7972();
            return !this.stickyStack.method_7960();
        }
        return false;
    }

    public class_1799 getStickyStack() {
        return this.stickyStack;
    }

    public boolean performAction(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        class_3414 event;
        boolean didAnything;
        if (action.isInsert()) {
            didAnything = this.playerInsert(player, hand, action, simulate);
        } else {
            didAnything = this.playerTakeDropLeftovers(player, hand, action, simulate);
            if (!didAnything && !this.stickyStack.method_7960()) {
                didAnything = true;
                this.stickyStack = class_1799.field_8037;
            }
        }
        this.updateStickyStack0();
        if (didAnything && this.field_11863 != null && Packages.instance.config.interactionSounds && !player.method_6059(class_1294.field_5905) && (event = action.getSoundEvent()) != null) {
            this.field_11863.method_8396(null, this.method_11016(), event, class_3419.field_15245, action.getSoundVolume(), action.getSoundPitch(this.field_11863));
        }
        return didAnything;
    }

    public boolean playerInsert(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        int x;
        int handSlot = PackageBlockEntity.handToSlotId(player, hand);
        if (!action.isInsert()) {
            throw new IllegalArgumentException("playerInsert only supports insertion actions, not " + action);
        }
        if (action == PackageAction.INSERT_ALL) {
            int favoriteSlot = player.method_5998(hand).method_7960() && this.container.method_5442() ? this.slotWithALot(player).orElse(handSlot) : handSlot;
            boolean didAnything = false;
            IntIterator iterator = PackageBlockEntity.handSlotFirst(player, favoriteSlot).intIterator();
            while (iterator.hasNext()) {
                int inserted = this.insert0(player, iterator.nextInt(), Integer.MAX_VALUE, simulate);
                if (inserted == 0) continue;
                didAnything = true;
            }
            return didAnything;
        }
        int n = x = action == PackageAction.INSERT_ONE ? 1 : Integer.MAX_VALUE;
        if (this.container.method_5442()) {
            return this.insert0(player, handSlot, x, simulate) > 0;
        }
        IntIterator iterator = PackageBlockEntity.handSlotFirst(player, handSlot).intIterator();
        while (iterator.hasNext()) {
            int inserted = this.insert0(player, iterator.nextInt(), x, simulate);
            if (inserted == 0) continue;
            return true;
        }
        return false;
    }

    private int insert0(class_1657 player, int slot, int maxAmountToInsert, boolean simulate) {
        class_1799 toInsert = player.method_31548().method_5438(slot).method_7972();
        class_1799 leftover = this.container.insert(toInsert, maxAmountToInsert, simulate);
        if (!simulate) {
            player.method_31548().method_5447(slot, leftover);
        }
        return toInsert.method_7947() - (leftover.method_7960() ? 0 : leftover.method_7947());
    }

    private Optional<Integer> slotWithALot(class_1657 player) {
        HashMap<class_1792, MutableInt> runningTotal = new HashMap<class_1792, MutableInt>();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 here = player.method_31548().method_5438(i);
            if (here.method_7960() || !this.container.allowedInPackageAtAll(here)) continue;
            runningTotal.computeIfAbsent(here.method_7909(), __ -> new MutableInt(0)).add(here.method_7947());
        }
        return runningTotal.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).flatMap(item -> {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                if (player.method_31548().method_5438(i).method_7909() != item) continue;
                return Optional.of(i);
            }
            return Optional.empty();
        });
    }

    public PlayerTakeResult playerTake(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        int maxAmountToTake = switch (action) {
            case PackageAction.TAKE_ONE -> 1;
            case PackageAction.TAKE_STACK -> {
                int completionAmount;
                class_1799 held = player.method_5998(hand);
                if (this.container.matches(held) && (completionAmount = held.method_7914() - held.method_7947()) > 0) {
                    yield completionAmount;
                }
                yield this.container.maxStackAmountAllowed(this.container.getFilterStack());
            }
            case PackageAction.TAKE_ALL -> Integer.MAX_VALUE;
            default -> throw new IllegalArgumentException("take() only supports taking actions, not " + action);
        };
        class_1799 toGiveOverstack = this.container.take(maxAmountToTake, simulate);
        if (toGiveOverstack.method_7960()) {
            return new PlayerTakeResult(false, Collections.emptyList());
        }
        if (simulate) {
            return new PlayerTakeResult(true, Collections.emptyList());
        }
        List<class_1799> toGive = PackageContainer.flattenOverstack(toGiveOverstack);
        ArrayList<class_1799> leftovers = new ArrayList<class_1799>();
        for (class_1799 stack : toGive) {
            if (player.method_31548().method_7394(stack)) continue;
            leftovers.add(stack);
        }
        return new PlayerTakeResult(true, leftovers);
    }

    private boolean playerTakeDropLeftovers(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        PlayerTakeResult result = this.playerTake(player, hand, action, simulate);
        if (simulate || !result.successful() || result.leftovers().isEmpty() || this.field_11863 == null) {
            return result.successful();
        }
        class_243 spawnPos = class_243.method_24953((class_2382)this.method_11016()).method_1019(new class_243(((TwelveDirection)((Object)this.method_11010().method_11654(PackageBlock.FACING))).primaryDirection.method_23955()).method_1021(0.8));
        for (class_1799 stack : result.leftovers()) {
            class_1542 e = new class_1542(this.field_11863, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, stack, 0.0, 0.01, 0.0);
            e.method_6982(10);
            this.field_11863.method_8649((class_1297)e);
        }
        return true;
    }

    private static int handToSlotId(class_1657 player, class_1268 hand) {
        return hand == class_1268.field_5808 ? player.method_31548().field_7545 : 40;
    }

    private static IntList handSlotFirst(class_1657 player, int handSlot) {
        int size = player.method_31548().method_5439();
        IntStream stream = handSlot == 0 ? IntStream.range(0, size) : (handSlot == size ? IntStream.concat(IntStream.of(handSlot), IntStream.range(0, size)) : IntStream.concat(IntStream.of(handSlot), IntStream.concat(IntStream.range(0, handSlot), IntStream.range(handSlot + 1, size))));
        return (IntList)stream.collect(IntArrayList::new, IntArrayList::add, IntList::addAll);
    }

    public int method_5439() {
        return this.container.method_5439();
    }

    public boolean method_5442() {
        return this.container.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.container.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.container.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.container.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.container.method_5447(slot, stack);
    }

    public int method_5444() {
        return this.container.method_5444();
    }

    public boolean method_5443(class_1657 player) {
        return this.container.method_5443(player);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (!this.stickyStack.method_7960() && !class_1799.method_31577((class_1799)this.stickyStack, (class_1799)stack)) {
            return false;
        }
        return this.container.method_5437(slot, stack);
    }

    public void method_5448() {
        this.container.method_5448();
    }

    public void method_5431() {
        this.updateStickyStack0();
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_2561 method_5477() {
        return this.method_16914() ? this.customName : ILoveMojang.translatable(((PackageBlock)((Object)PBlocks.PACKAGE.get())).method_9539(), new Object[0]);
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public Object getRenderAttachmentData() {
        return this.getStyle();
    }

    public void method_11007(class_2487 tag) {
        tag.method_10566("PackageContents", (class_2520)this.container.toTag());
        tag.method_10566("PackageStyle", (class_2520)this.style.toTag());
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10566("StickyStack", (class_2520)this.stickyStack.method_7953(new class_2487()));
        super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.container.readFromTag(tag.method_10562("PackageContents"));
        this.style = PackageStyle.fromTag(tag.method_10562("PackageStyle"));
        this.customName = tag.method_10573("CustomName", 8) ? class_2561.class_2562.method_10877((String)tag.method_10558("CustomName")) : null;
        this.stickyStack = class_1799.method_7915((class_2487)tag.method_10562("StickyStack"));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public record PlayerTakeResult(boolean successful, List<class_1799> leftovers) {
    }
}

