/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.client;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.client.PackagesClient;
import agency.highlysuspect.packages.junk.PUtil;
import agency.highlysuspect.packages.junk.PackageMakerStyle;
import agency.highlysuspect.packages.junk.PackageStyle;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public interface PackageModelBakery<T> {
    public class_1087 getBaseModel();

    public T bake(@Nullable Object var1, @Nullable class_1767 var2, @Nullable class_2248 var3, @Nullable class_2248 var4);

    default public T bake(@Nullable PackageStyle style) {
        if (style == null) {
            return this.bake(null, null, null, null);
        }
        return this.bake(style, style.color(), style.frameBlock(), style.innerBlock());
    }

    default public T bake(@Nullable PackageMakerStyle style) {
        if (style == null) {
            return this.bake(null, null, null, null);
        }
        return this.bake(style, style.color(), style.frameBlock(), style.innerBlock());
    }

    public static abstract class Factory<T> {
        private static final class_4730 SPECIAL_FRAME = new class_4730(class_1059.field_5275, Packages.id("special/frame"));
        private static final class_4730 SPECIAL_INNER = new class_4730(class_1059.field_5275, Packages.id("special/inner"));
        private final class_2960 blockModelId;

        public Factory(class_2960 blockModelId) {
            this.blockModelId = blockModelId;
        }

        public Collection<class_2960> getDependencies() {
            return ImmutableList.of((Object)this.blockModelId);
        }

        public Collection<class_4730> getMaterials(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
            return PUtil.concat(new Collection[]{unbakedModelGetter.apply(this.blockModelId).method_4754(unbakedModelGetter, unresolvedTextureReferences), ImmutableList.of((Object)SPECIAL_FRAME, (Object)SPECIAL_INNER)});
        }

        public PackageModelBakery<T> make(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
            class_1087 baseModel = loader.method_4726(this.blockModelId).method_4753(loader, textureGetter, rotationContainer, modelId);
            class_1058 specialFrameSprite = textureGetter.apply(SPECIAL_FRAME);
            class_1058 specialInnerSprite = textureGetter.apply(SPECIAL_INNER);
            PackageModelBakery<T> bakery = this.make(baseModel, specialFrameSprite, specialInnerSprite);
            if (PackagesClient.instance.config.cacheMeshes) {
                bakery = new Caching<T>(bakery);
            }
            return bakery;
        }

        public abstract PackageModelBakery<T> make(class_1087 var1, class_1058 var2, class_1058 var3);
    }

    public static class Caching<T>
    implements PackageModelBakery<T> {
        private final PackageModelBakery<T> uncached;
        private final Map<Object, T> cache = new HashMap<Object, T>();
        private final Object UPDATE_LOCK = new Object();

        public Caching(PackageModelBakery<T> uncached) {
            this.uncached = uncached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T bake(@Nullable Object cacheKey, @Nullable class_1767 faceColor, @Nullable class_2248 frameBlock, @Nullable class_2248 innerBlock) {
            T result = this.cache.get(cacheKey);
            if (result != null) {
                return result;
            }
            result = this.uncached.bake(cacheKey, faceColor, frameBlock, innerBlock);
            Object object = this.UPDATE_LOCK;
            synchronized (object) {
                this.cache.put(cacheKey, result);
            }
            return result;
        }

        @Override
        public class_1087 getBaseModel() {
            return this.uncached.getBaseModel();
        }
    }
}

