/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.junk;

import agency.highlysuspect.packages.item.PItems;
import agency.highlysuspect.packages.junk.PTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5537;
import org.jetbrains.annotations.Nullable;

public class PackageContainer
implements class_1263 {
    public static final int SLOT_COUNT = 8;
    public static final int RECURSION_LIMIT = 3;
    public static final String KEY = "PackageContents";
    private final class_2371<class_1799> inv = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private final List<class_1265> listeners = new ArrayList<class_1265>();

    public PackageContainer addListener(class_1265 listener) {
        this.listeners.add(listener);
        return this;
    }

    public void removeListener(class_1265 listener) {
        this.listeners.remove(listener);
    }

    public class_1799 getFilterStack() {
        for (class_1799 stack : this.inv) {
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public int getCount() {
        int count = 0;
        for (class_1799 stack : this.inv) {
            count += stack.method_7947();
        }
        return count;
    }

    public class_1799 computeRootContents() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        return subcontents == null ? this.getFilterStack() : subcontents.computeRootContents();
    }

    public int computeFullyMultipliedCount() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        return (subcontents == null ? 1 : subcontents.computeFullyMultipliedCount()) * this.getCount();
    }

    public boolean computeAmplificationStatus() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        if (subcontents != null) {
            return this.getCount() > 1 || subcontents.computeAmplificationStatus();
        }
        return false;
    }

    public boolean isFull() {
        return class_3532.method_15347((float)this.fillPercentage(), (float)1.0f);
    }

    public float fillPercentage() {
        int maxCount = this.maxStackAmountAllowed(this.getFilterStack()) * 8;
        if (maxCount == 0) {
            return 1.0f;
        }
        return (float)this.getCount() / (float)maxCount;
    }

    public boolean allowedInPackageAtAll(class_1799 stack) {
        class_1747 bi;
        if (stack.method_31573(PTags.BANNED_FROM_PACKAGE)) {
            return false;
        }
        boolean checkCanFitInsideContainerItems = true;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() instanceof class_2480) {
            checkCanFitInsideContainerItems = false;
            class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
            if (blockEntityTag != null && !blockEntityTag.method_10554("Items", 10).isEmpty()) {
                return false;
            }
        }
        if (stack.method_7909() instanceof class_5537) {
            checkCanFitInsideContainerItems = false;
            if (stack.method_31578()) {
                return false;
            }
        }
        if (checkCanFitInsideContainerItems && !stack.method_7909().method_31568()) {
            return false;
        }
        PackageContainer cont = PackageContainer.fromItemStack(stack);
        if (cont == null) {
            return true;
        }
        return cont.calcRecursionLevel() < 3;
    }

    public int maxStackAmountAllowed(class_1799 stack) {
        PackageContainer recur = PackageContainer.fromItemStack(stack);
        if (recur != null && recur.getCount() > 0) {
            return 1;
        }
        return Math.min(stack.method_7914(), 64);
    }

    private int calcRecursionLevel() {
        PackageContainer recur = PackageContainer.fromItemStack(this.getFilterStack());
        if (recur == null) {
            return 0;
        }
        return 1 + recur.calcRecursionLevel();
    }

    public boolean matches(class_1799 stack) {
        class_1799 filter = this.getFilterStack();
        if (filter.method_7960() || stack.method_7960()) {
            return true;
        }
        return class_1799.method_31577((class_1799)filter, (class_1799)stack);
    }

    public class_1799 insert(class_1799 toInsert, int maxAmountToInsert, boolean simulate) {
        if (toInsert.method_7960() || !this.matches(toInsert) || !this.allowedInPackageAtAll(toInsert)) {
            return toInsert;
        }
        int remainingAmountToInsert = Math.min(toInsert.method_7947(), maxAmountToInsert);
        int amountInserted = 0;
        int maxStackAmountPerSlot = this.maxStackAmountAllowed(toInsert);
        for (int slot = 0; slot < 8 && remainingAmountToInsert > 0; ++slot) {
            class_1799 newStack;
            int amountToInsertThisSlot = Math.min(remainingAmountToInsert, maxStackAmountPerSlot);
            class_1799 currentStack = this.method_5438(slot);
            if (currentStack.method_7960()) {
                newStack = toInsert.method_7972();
                newStack.method_7939(amountToInsertThisSlot);
            } else {
                int remainingSpaceThisSlot = maxStackAmountPerSlot - currentStack.method_7947();
                if (remainingSpaceThisSlot <= 0) continue;
                amountToInsertThisSlot = Math.min(amountToInsertThisSlot, remainingSpaceThisSlot);
                newStack = simulate ? currentStack.method_7972() : currentStack;
                newStack.method_7933(amountToInsertThisSlot);
            }
            remainingAmountToInsert -= amountToInsertThisSlot;
            amountInserted += amountToInsertThisSlot;
            if (simulate) continue;
            this.method_5447(slot, newStack);
        }
        class_1799 remaining = toInsert.method_7972();
        remaining.method_7934(amountInserted);
        return remaining;
    }

    public class_1799 take(int maxAmountToTake, boolean simulate) {
        class_1799 filter = this.getFilterStack();
        if (filter.method_7960()) {
            return class_1799.field_8037;
        }
        int remainingAmountToTake = maxAmountToTake;
        int amountTook = 0;
        for (int slot = 7; slot >= 0 && remainingAmountToTake > 0; --slot) {
            class_1799 newStack;
            class_1799 currentStack = this.method_5438(slot);
            if (currentStack.method_7960()) continue;
            int amountToTakeThisSlot = Math.min(remainingAmountToTake, currentStack.method_7947());
            if (amountToTakeThisSlot == currentStack.method_7947()) {
                newStack = class_1799.field_8037;
            } else {
                newStack = simulate ? currentStack.method_7972() : currentStack;
                newStack.method_7934(amountToTakeThisSlot);
            }
            remainingAmountToTake -= amountToTakeThisSlot;
            amountTook += amountToTakeThisSlot;
            if (simulate) continue;
            this.method_5447(slot, newStack);
        }
        filter = filter.method_7972();
        filter.method_7939(amountTook);
        return filter;
    }

    public static List<class_1799> flattenOverstack(class_1799 mutOverstack) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        while (!mutOverstack.method_7960()) {
            result.add(mutOverstack.method_7971(mutOverstack.method_7914()));
        }
        return result;
    }

    public int method_5439() {
        return 8;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inv) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inv.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.method_5431();
        return class_1262.method_5430(this.inv, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        this.method_5431();
        return class_1262.method_5428(this.inv, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inv.set(slot, (Object)stack);
        this.method_5431();
    }

    public int method_5444() {
        return this.maxStackAmountAllowed(this.getFilterStack());
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (!this.allowedInPackageAtAll(stack)) {
            return false;
        }
        PackageContainer hereContainer = PackageContainer.fromItemStack(this.method_5438(slot));
        if (hereContainer != null && !hereContainer.method_5442()) {
            return false;
        }
        return this.matches(stack);
    }

    public void method_5431() {
        for (class_1265 l : this.listeners) {
            l.method_5453((class_1263)this);
        }
    }

    public void method_5448() {
        this.inv.clear();
        this.method_5431();
    }

    public class_2487 toTag() {
        return this.toTag(new class_2487());
    }

    public class_2487 toTag(class_2487 writeTo) {
        class_1799 first = this.getFilterStack();
        if (!first.method_7960()) {
            class_2487 stackTag = this.getFilterStack().method_7953(new class_2487());
            stackTag.method_10567("Count", (byte)1);
            writeTo.method_10566("stack", (class_2520)stackTag);
            writeTo.method_10569("realCount", this.getCount());
        } else {
            writeTo.method_10569("realCount", 0);
        }
        return writeTo;
    }

    public void readFromTag(class_2487 tag) {
        this.method_5448();
        int count = tag.method_10550("realCount");
        if (count != 0) {
            class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562("stack"));
            int maxPerSlot = this.maxStackAmountAllowed(stack);
            int remaining = count;
            for (int slot = 0; remaining > 0 && slot < 8; remaining -= maxPerSlot, ++slot) {
                class_1799 toInsert = stack.method_7972();
                toInsert.method_7939(Math.min(remaining, maxPerSlot));
                this.method_5447(slot, toInsert);
            }
        }
    }

    public static PackageContainer fromTag(class_2487 tag) {
        PackageContainer r = new PackageContainer();
        r.readFromTag(tag);
        return r;
    }

    @Nullable
    public static PackageContainer fromItemStack(class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() != PItems.PACKAGE.get()) {
            return null;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        return PackageContainer.fromTag(tag.method_10562("BlockEntityTag").method_10562(KEY));
    }

    public static boolean existsOnItemStack(class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() != PItems.PACKAGE.get()) {
            return false;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return false;
        }
        class_2487 blockEntityTag = tag.method_10562("BlockEntityTag");
        if (blockEntityTag == null || blockEntityTag.method_33133()) {
            return false;
        }
        class_2487 key = blockEntityTag.method_10562(KEY);
        return key != null && !key.method_33133();
    }

    public class_1799 writeToStackTag(class_1799 stack) {
        stack.method_7911("BlockEntityTag").method_10566(KEY, (class_2520)this.toTag());
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T mutateItemStack(class_1799 stack, Function<PackageContainer, T> action, T ifNoContainer) {
        PackageContainer cont = PackageContainer.fromItemStack(stack);
        if (cont == null) {
            return ifNoContainer;
        }
        try {
            T t = action.apply(cont);
            return t;
        }
        finally {
            cont.writeToStackTag(stack);
        }
    }
}

