/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.fabric;

import agency.highlysuspect.packages.Packages;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public abstract class AbstractFabricPlatformConfig {
    public static boolean FIRST_RUN_WITH_SPLIT_CONFIGS = false;

    protected abstract boolean parseKeyValuePair(String var1, String var2);

    protected abstract List<String> write();

    protected abstract void install();

    protected void parse(Path configPath, List<String> lines) {
        int lineNo = 0;
        for (String line : lines) {
            int eqIndex;
            ++lineNo;
            if ((line = line.trim()).startsWith("#") || (eqIndex = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, eqIndex).trim();
            String value = line.substring(eqIndex + 1).trim();
            try {
                boolean knownKey = this.parseKeyValuePair(key, value);
                if (knownKey || FIRST_RUN_WITH_SPLIT_CONFIGS) continue;
                Packages.LOGGER.warn("unknown config key " + key);
            }
            catch (Exception e) {
                Packages.LOGGER.warn("Exception while parsing line " + lineNo + " of the config file at " + configPath);
                Packages.LOGGER.warn("---");
                Packages.LOGGER.warn(line);
                Packages.LOGGER.warn("---");
                Packages.LOGGER.warn("Configuration state may be inconsistent.");
                Packages.LOGGER.warn((Object)e);
            }
        }
    }

    public void setup(class_3264 type, String filename) {
        final Path configPath = FabricLoader.getInstance().getConfigDir().resolve(filename);
        this.configStuff(configPath);
        ResourceManagerHelper.get((class_3264)type).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return Packages.id("fabric-config-reload");
            }

            public void method_14491(class_3300 resourceManager) {
                AbstractFabricPlatformConfig.this.configStuff(configPath);
            }
        });
    }

    private void configStuff(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (Files.exists(configPath, new LinkOption[0])) {
                this.parse(configPath, Files.readAllLines(configPath));
            }
            this.install();
            Files.write(configPath, this.write(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

