/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.fabric;

import agency.highlysuspect.packages.net.ActionPacket;
import agency.highlysuspect.packages.platform.CommonPlatformConfig;
import agency.highlysuspect.packages.platform.PlatformSupport;
import agency.highlysuspect.packages.platform.fabric.AbstractFabricPlatformConfig;
import agency.highlysuspect.packages.platform.fabric.FabricCommonPlatformConfig;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class FabricPlatformSupport
implements PlatformSupport {
    public FabricPlatformSupport() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            Path legacyConfigFile = configDir.resolve("packages.cfg");
            Path newCommonConfigFile = configDir.resolve("packages-common.cfg");
            Path newClientConfigFile = configDir.resolve("packages-client.cfg");
            if (Files.exists(legacyConfigFile, new LinkOption[0]) && !Files.exists(newCommonConfigFile, new LinkOption[0]) && !Files.exists(newClientConfigFile, new LinkOption[0])) {
                Files.copy(legacyConfigFile, newCommonConfigFile, new CopyOption[0]);
                Files.copy(legacyConfigFile, newClientConfigFile, new CopyOption[0]);
                Files.delete(legacyConfigFile);
            }
            AbstractFabricPlatformConfig.FIRST_RUN_WITH_SPLIT_CONFIGS = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> PlatformSupport.RegistryHandle<T> register(class_2378<? super T> registry, class_2960 id, Supplier<T> thingMaker) {
        T thing = thingMaker.get();
        class_2378.method_10230(registry, (class_2960)id, thing);
        return new ImmediateRegistryHandle<T>(thing, id);
    }

    @Override
    public <T extends class_2586> class_2591<T> makeBlockEntityType(PlatformSupport.BlockEntityFactory<T> factory, class_2248 ... blocks) {
        return FabricBlockEntityTypeBuilder.create(factory::create, (class_2248[])blocks).build();
    }

    @Override
    public class_1761 makeCreativeModeTab(class_2960 id, Supplier<class_1799> icon) {
        return FabricItemGroupBuilder.build((class_2960)id, icon);
    }

    @Override
    public void registerDispenserBehavior(PlatformSupport.RegistryHandle<? extends class_1935> item, class_2357 behavior) {
        class_2315.method_10009((class_1935)((class_1935)item.get()), (class_2357)behavior);
    }

    @Override
    public <T extends class_1703> class_3917<T> makeMenuType(PlatformSupport.MyMenuSupplier<T> supplier) {
        return new class_3917(supplier::create);
    }

    @Override
    public void registerActionPacketHandler() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ActionPacket.LONG_ID, (server, player, handler, buf, resp) -> ActionPacket.read(buf).handle(player));
    }

    @Override
    public CommonPlatformConfig makePlatformConfig() {
        return new FabricCommonPlatformConfig();
    }

    private static class ImmediateRegistryHandle<T>
    implements PlatformSupport.RegistryHandle<T> {
        private final T thing;
        private final class_2960 id;

        public ImmediateRegistryHandle(T thing, class_2960 id) {
            this.thing = thing;
            this.id = id;
        }

        @Override
        public T get() {
            return this.thing;
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }
    }
}

