/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.handlers;

import crystalspider.harvestwithease.HarvestWithEaseLoader;
import crystalspider.harvestwithease.config.HarvestWithEaseConfig;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_5321;

public class UseBlockHandler {
    public class_1269 handle(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        class_2338 blockPos;
        class_2680 blockState;
        class_1269 actionResult = class_1269.field_5811;
        if (!player.method_7325() && this.isCrop((blockState = world.method_8320(blockPos = result.method_17777())).method_26204()) && this.getInteractionHand(player) == hand && this.canHarvest(player.method_5998(hand), blockState)) {
            try {
                class_2758 age = this.getAge(blockState);
                if (blockState.method_28500((class_2769)age).orElse(0) >= (Integer)Collections.max(age.method_11898())) {
                    actionResult = class_1269.field_5812;
                    if (!world.method_8608()) {
                        this.grantExp(player);
                        this.damageHoe(player, hand);
                        this.dropResources(world.method_8503().method_3847(world.method_27983()), blockState, result.method_17780(), blockPos, player, hand);
                        world.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)age, (Comparable)Integer.valueOf(0)));
                        this.playSound(world, blockState, blockPos);
                    }
                }
            }
            catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                HarvestWithEaseLoader.LOGGER.debug("Exception generated by block at [" + blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260() + "]");
                HarvestWithEaseLoader.LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod harvestwithease");
                HarvestWithEaseLoader.LOGGER.debug("Most probably the cause of this issue was that a non-crop ID was added in the configuration and its age property could not be retrieved, see stack trace for more details", (Throwable)e);
            }
        }
        return actionResult;
    }

    private void grantExp(class_1657 player) {
        if (HarvestWithEaseConfig.getGrantedExp() > 0) {
            player.method_7255(HarvestWithEaseConfig.getGrantedExp().intValue());
        }
    }

    private void damageHoe(class_1657 player, class_1268 interactionHand) {
        if (HarvestWithEaseConfig.getRequireHoe().booleanValue() && HarvestWithEaseConfig.getDamageOnHarvest() > 0 && !player.method_7337()) {
            player.method_5998(interactionHand).method_7956(HarvestWithEaseConfig.getDamageOnHarvest().intValue(), (class_1309)player, playerEntity -> playerEntity.method_20236(interactionHand));
        }
    }

    private void dropResources(class_3218 serverWorld, class_2680 blockState, class_2350 direction, class_2338 blockPos, class_1657 player, class_1268 interactionHand) {
        List<class_1799> drops = this.getDrops(serverWorld, blockState, blockPos, player, interactionHand);
        boolean seedRemoved = false;
        for (class_1799 stack : drops) {
            if (!seedRemoved && stack.method_7929(blockState.method_26204().method_9574((class_1922)serverWorld, blockPos, blockState))) {
                stack.method_7934(1);
                seedRemoved = true;
            }
            class_2248.method_36992((class_1937)serverWorld, (class_2338)blockPos, (class_2350)direction, (class_1799)stack);
        }
    }

    private List<class_1799> getDrops(class_3218 serverWorld, class_2680 blockState, class_2338 blockPos, class_1657 player, class_1268 interactionHand) {
        return blockState.method_26189(new class_47.class_48(serverWorld).method_312(class_181.field_24424, (Object)new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260())).method_312(class_181.field_1224, (Object)blockState).method_312(class_181.field_1226, (Object)player).method_312(class_181.field_1229, (Object)player.method_5998(interactionHand)));
    }

    private void playSound(class_1937 world, class_2680 blockState, class_2338 blockPos) {
        if (HarvestWithEaseConfig.getPlaySound().booleanValue()) {
            class_2498 soundGroup = blockState.method_26204().method_9573(blockState);
            world.method_8396(null, blockPos, soundGroup.method_10595(), class_3419.field_15245, soundGroup.method_10597(), soundGroup.method_10599());
        }
    }

    private class_2758 getAge(class_2680 blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (class_2758)blockState.method_28501().stream().filter(property -> property.method_11899().equals("age")).findFirst().orElseThrow();
    }

    @Nullable
    private class_1268 getInteractionHand(class_1657 player) {
        if (!player.method_5715()) {
            if (this.isHoe(player.method_5998(class_1268.field_5808))) {
                return class_1268.field_5808;
            }
            if (this.isHoe(player.method_5998(class_1268.field_5810))) {
                return class_1268.field_5810;
            }
            if (!HarvestWithEaseConfig.getRequireHoe().booleanValue()) {
                return class_1268.field_5808;
            }
        }
        return null;
    }

    private boolean isHoe(class_1799 handItem) {
        return handItem.method_7909() instanceof class_1794;
    }

    private boolean isCrop(class_2248 block) {
        return block instanceof class_2302 || block == class_2246.field_9974 || block == class_2246.field_10302 || HarvestWithEaseConfig.getCrops().contains(this.getKey(block));
    }

    private boolean canHarvest(class_1799 itemStack, class_2680 blockState) {
        return !blockState.method_29291() || itemStack.method_7951(blockState);
    }

    private String getKey(class_2248 block) {
        return ((class_5321)class_2378.field_11146.method_29113((Object)block).get()).method_29177().toString();
    }
}

