/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.PolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.PolymorphPacketDistributor;
import top.theillusivec4.polymorph.api.common.base.RecipePair;
import top.theillusivec4.polymorph.api.common.component.BlockEntityRecipeData;
import top.theillusivec4.polymorph.common.component.PolymorphComponents;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;

public class CommonEventsListener {
    private static final Map<class_2586, BlockEntityRecipeData> TICKABLE_BLOCKS = new ConcurrentHashMap<class_2586, BlockEntityRecipeData>();

    public static void setup() {
        ServerLifecycleEvents.SERVER_STARTING.register(CommonEventsListener::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(CommonEventsListener::serverStopped);
        ServerTickEvents.END_WORLD_TICK.register(CommonEventsListener::worldTick);
    }

    public static void addTickableBlock(class_2586 be) {
        PolymorphComponents.getRecipeData(be).ifPresent(recipeData -> TICKABLE_BLOCKS.put(be, (BlockEntityRecipeData)recipeData));
    }

    public static void openScreenHandler(class_3222 player) {
        class_1703 screenHandler = player.field_7512;
        PolymorphCommon commonApi = PolymorphApi.common();
        commonApi.getRecipeDataFromBlockEntity(screenHandler).ifPresent(recipeData -> {
            PolymorphPacketDistributor packetDistributor = commonApi.getPacketDistributor();
            if (recipeData.isFailing() || recipeData.isEmpty(null)) {
                packetDistributor.sendRecipesListS2C(player);
            } else {
                class_3545<SortedSet<RecipePair>, class_2960> data = recipeData.getPacketData();
                packetDistributor.sendRecipesListS2C(player, (SortedSet)data.method_15442(), (class_2960)data.method_15441());
            }
        });
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            if (!integration.openScreenHandler(screenHandler, player)) continue;
            return;
        }
    }

    private static void worldTick(class_3218 serverWorld) {
        ArrayList<class_2586> toRemove = new ArrayList<class_2586>();
        for (Map.Entry<class_2586, BlockEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            class_2586 be = entry.getKey();
            class_1937 beWorld = be.method_10997();
            if (be.method_11015() || beWorld == null || beWorld.method_8608()) {
                toRemove.add(be);
                continue;
            }
            entry.getValue().tick();
        }
        for (class_2586 be : toRemove) {
            TICKABLE_BLOCKS.remove(be);
        }
    }

    private static void serverStopped(MinecraftServer server) {
        PolymorphApi.common().setServer(null);
        TICKABLE_BLOCKS.clear();
    }

    private static void serverStarting(MinecraftServer server) {
        PolymorphApi.common().setServer(server);
        TICKABLE_BLOCKS.clear();
    }
}

