/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.component;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.RecipePair;
import top.theillusivec4.polymorph.api.common.component.BlockEntityRecipeData;
import top.theillusivec4.polymorph.common.component.AbstractRecipeData;

public abstract class AbstractBlockEntityRecipeData<E extends class_2586>
extends AbstractRecipeData<class_2586>
implements BlockEntityRecipeData {
    private class_2371<class_1799> lastInput = class_2371.method_10211();

    public AbstractBlockEntityRecipeData(E pOwner) {
        super(pOwner);
    }

    protected abstract class_2371<class_1799> getInput();

    @Override
    public void tick() {
        boolean changed = false;
        class_2371<class_1799> currentInput = this.getInput();
        this.lastInput = this.validateList(this.lastInput, currentInput.size());
        for (int i = 0; i < currentInput.size(); ++i) {
            class_1799 currentStack;
            class_1799 lastStack = (class_1799)this.lastInput.get(i);
            if (!class_1799.method_7973((class_1799)lastStack, (class_1799)(currentStack = (class_1799)currentInput.get(i)))) {
                changed = true;
            }
            this.lastInput.set(i, (Object)currentStack.method_7972());
        }
        if (changed) {
            this.sendRecipesListToListeners(this.isFailing() || this.isEmpty());
        }
    }

    private class_2371<class_1799> validateList(class_2371<class_1799> pList, int pSize) {
        if (pList.size() == pSize) {
            return pList;
        }
        class_2371 resized = class_2371.method_10213((int)pSize, (Object)class_1799.field_8037);
        for (int i = 0; i < Math.min(resized.size(), pList.size()); ++i) {
            resized.set(i, (Object)((class_1799)pList.get(i)));
        }
        return resized;
    }

    @Override
    public Set<class_3222> getListeners() {
        class_1937 world = this.getOwner().method_10997();
        HashSet<class_3222> players = new HashSet<class_3222>();
        if (world instanceof class_3218) {
            for (class_3222 player : ((class_3218)world).method_8410().method_18456()) {
                PolymorphApi.common().getRecipeDataFromBlockEntity(player.field_7512).ifPresent(recipeData -> {
                    if (recipeData == this) {
                        players.add(player);
                    }
                });
            }
        }
        return players;
    }

    @Override
    public E getOwner() {
        return (E)((class_2586)super.getOwner());
    }

    public boolean isEmpty() {
        for (class_1799 stack : this.getInput()) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_3545<SortedSet<RecipePair>, class_2960> getPacketData() {
        return new class_3545(this.getRecipesList(), null);
    }

    @Override
    public boolean isEmpty(class_1263 pInventory) {
        return this.isEmpty();
    }
}

