/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.component;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.RecipePair;
import top.theillusivec4.polymorph.api.common.component.RecipeData;
import top.theillusivec4.polymorph.api.common.event.PolymorphRecipeEvents;
import top.theillusivec4.polymorph.common.PolymorphMod;
import top.theillusivec4.polymorph.common.impl.RecipePairImpl;

public abstract class AbstractRecipeData<E>
implements RecipeData<E> {
    private final SortedSet<RecipePair> recipesList = new TreeSet<RecipePair>();
    private final E owner;
    private class_1860<?> lastRecipe;
    private class_1860<?> selectedRecipe;
    private class_2960 loadedRecipe;
    private boolean isFailing;

    public AbstractRecipeData(E pOwner) {
        this.owner = pOwner;
    }

    @Override
    public <T extends class_1860<C>, C extends class_1263> Optional<T> getRecipe(class_3956<T> pType, C pInventory, class_1937 pWorld, List<T> pRecipes) {
        this.getLoadedRecipe().flatMap(id -> pWorld.method_8433().method_8130(id)).ifPresent(selected -> {
            try {
                if (selected.method_17716() == pType && (selected.method_8115(pInventory, pWorld) || this.isEmpty(pInventory))) {
                    this.setSelectedRecipe((class_1860<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.method_8114(), (Object)pInventory);
            }
            this.loadedRecipe = null;
        });
        if (this.isEmpty(pInventory)) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.method_17716() == pType && recipe.method_8115(pInventory, pWorld)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.method_17716() == pType && selected.method_8115(pInventory, pWorld)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.method_8114(), (Object)pInventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)recipe.method_8114(), (Object)pInventory);
            }
        });
        class_1860 result = ref.get();
        if (result != null) {
            this.setFailing(false);
            this.sendRecipesListToListeners(false);
            return Optional.of(result);
        }
        TreeSet<RecipePair> newDataset = new TreeSet<RecipePair>();
        List recipes = pRecipes.isEmpty() ? pWorld.method_8433().method_17877(pType, pInventory, pWorld) : pRecipes;
        ((PolymorphRecipeEvents.FetchRecipes)PolymorphRecipeEvents.FETCH_RECIPES.invoker()).modify(this, recipes);
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        for (class_1860 entry : recipes) {
            class_2960 id2 = entry.method_8114();
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.method_8114().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            newDataset.add(new RecipePairImpl(id2, entry.method_8116(pInventory)));
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        this.lastRecipe = result = result != null ? result : (class_1860)recipes.get(0);
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<? extends class_1860<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(class_1860<?> pRecipe) {
        this.selectedRecipe = pRecipe;
    }

    public Optional<? extends class_1860<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<class_2960> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    public SortedSet<RecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(SortedSet<RecipePair> pData) {
        this.recipesList.clear();
        this.recipesList.addAll(pData);
    }

    @Override
    public boolean isEmpty(class_1263 pInventory) {
        if (pInventory != null) {
            for (int i = 0; i < pInventory.method_5439(); ++i) {
                if (pInventory.method_5438(i).method_7960()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(class_1860<?> pRecipe) {
        this.setSelectedRecipe(pRecipe);
    }

    @Override
    public abstract Set<class_3222> getListeners();

    @Override
    public void sendRecipesListToListeners(boolean pEmpty) {
        class_3545 packetData = pEmpty ? new class_3545(new TreeSet(), null) : this.getPacketData();
        for (class_3222 listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.method_15442(), (class_2960)packetData.method_15441());
        }
    }

    @Override
    public class_3545<SortedSet<RecipePair>, class_2960> getPacketData() {
        return new class_3545(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean pFailing) {
        this.isFailing = pFailing;
    }

    @Override
    public void readNbt(class_2487 pCompound) {
        if (pCompound.method_10545("SelectedRecipe")) {
            this.loadedRecipe = new class_2960(pCompound.method_10558("SelectedRecipe"));
        }
        if (pCompound.method_10545("RecipeDataSet")) {
            SortedSet<RecipePair> dataset = this.getRecipesList();
            dataset.clear();
            class_2499 list = pCompound.method_10554("RecipeDataSet", 10);
            for (class_2520 inbt : list) {
                class_2487 tag = (class_2487)inbt;
                class_2960 id = class_2960.method_12829((String)tag.method_10558("Id"));
                class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
                dataset.add(new RecipePairImpl(id, stack));
            }
        }
    }

    @Override
    public class_2487 writeNbt() {
        class_2487 nbt = new class_2487();
        this.getSelectedRecipe().ifPresent(selected -> nbt.method_10582("SelectedRecipe", this.selectedRecipe.method_8114().toString()));
        SortedSet<RecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            class_2499 list = new class_2499();
            for (RecipePair data : dataset) {
                class_2487 tag = new class_2487();
                tag.method_10566("ItemStack", (class_2520)data.getOutput().method_7953(new class_2487()));
                tag.method_10582("Id", data.getIdentifier().toString());
                list.add((Object)tag);
            }
            nbt.method_10566("RecipeDataSet", (class_2520)list);
        }
        return nbt;
    }
}

