/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.server.MinecraftServer;
import top.theillusivec4.polymorph.api.common.base.PolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.PolymorphPacketDistributor;
import top.theillusivec4.polymorph.api.common.component.BlockEntityRecipeData;
import top.theillusivec4.polymorph.api.common.component.PlayerRecipeData;
import top.theillusivec4.polymorph.api.common.component.StackRecipeData;
import top.theillusivec4.polymorph.common.component.PolymorphComponents;
import top.theillusivec4.polymorph.common.impl.PolymorphPacketDistributorImpl;

public class PolymorphCommonImpl
implements PolymorphCommon {
    private static final PolymorphCommon INSTANCE = new PolymorphCommonImpl();
    private final List<PolymorphCommon.ScreenHandler2BlockEntity> screenHandler2BlockEntities = new ArrayList<PolymorphCommon.ScreenHandler2BlockEntity>();
    private final List<PolymorphCommon.ScreenHandler2ItemStack> screenHandler2ItemStacks = new ArrayList<PolymorphCommon.ScreenHandler2ItemStack>();
    private final PolymorphPacketDistributor distributor = new PolymorphPacketDistributorImpl();
    private final Map<class_1792, PolymorphCommon.Item2RecipeData> itemStack2RecipeData = new HashMap<class_1792, PolymorphCommon.Item2RecipeData>();
    private final Map<Class<? extends class_2586>, PolymorphCommon.BlockEntity2RecipeData> blockEntity2RecipeData = new HashMap<Class<? extends class_2586>, PolymorphCommon.BlockEntity2RecipeData>();
    private MinecraftServer server = null;

    public static PolymorphCommon get() {
        return INSTANCE;
    }

    @Override
    public Map<Class<? extends class_2586>, PolymorphCommon.BlockEntity2RecipeData> getAllBlockRecipeData() {
        return ImmutableMap.copyOf(this.blockEntity2RecipeData);
    }

    @Override
    public Optional<BlockEntityRecipeData> getRecipeData(class_2586 pBlockEntity) {
        return PolymorphComponents.getRecipeData(pBlockEntity);
    }

    @Override
    public Optional<BlockEntityRecipeData> getRecipeDataFromBlockEntity(class_1703 pScreenHandler) {
        for (PolymorphCommon.ScreenHandler2BlockEntity function : this.screenHandler2BlockEntities) {
            class_2586 blockEntity = function.getBlockEntity(pScreenHandler);
            if (blockEntity == null) continue;
            return this.getRecipeData(blockEntity);
        }
        return Optional.empty();
    }

    @Override
    public Map<class_1792, PolymorphCommon.Item2RecipeData> getAllItemRecipeData() {
        return ImmutableMap.copyOf(this.itemStack2RecipeData);
    }

    @Override
    public Optional<StackRecipeData> getRecipeData(class_1799 pStack) {
        return PolymorphComponents.getRecipeData(pStack);
    }

    @Override
    public Optional<StackRecipeData> getRecipeDataFromItemStack(class_1703 pScreenHandler) {
        for (PolymorphCommon.ScreenHandler2ItemStack function : this.screenHandler2ItemStacks) {
            class_1799 itemstack = function.getItemStack(pScreenHandler);
            if (itemstack.method_7960()) continue;
            return this.getRecipeData(itemstack);
        }
        return Optional.empty();
    }

    @Override
    public Optional<PlayerRecipeData> getRecipeData(class_1657 pPlayer) {
        return PolymorphComponents.getRecipeData(pPlayer);
    }

    @Override
    public void registerBlockEntity2RecipeData(Class<? extends class_2586> pBlockEntity, PolymorphCommon.BlockEntity2RecipeData pBlockEntity2RecipeData) {
        this.blockEntity2RecipeData.put(pBlockEntity, pBlockEntity2RecipeData);
    }

    @Override
    public void registerScreenHandler2BlockEntity(PolymorphCommon.ScreenHandler2BlockEntity pScreenHandler2BlockEntity) {
        this.screenHandler2BlockEntities.add(0, pScreenHandler2BlockEntity);
    }

    @Override
    public void registerItem2RecipeData(class_1792 pItem, PolymorphCommon.Item2RecipeData pItemStack2RecipeData) {
        this.itemStack2RecipeData.put(pItem, pItemStack2RecipeData);
    }

    @Override
    public void registerScreenHandler2ItemStack(PolymorphCommon.ScreenHandler2ItemStack pScreenHandler2ItemStack) {
        this.screenHandler2ItemStacks.add(0, pScreenHandler2ItemStack);
    }

    @Override
    public PolymorphPacketDistributor getPacketDistributor() {
        return this.distributor;
    }

    @Override
    public void setServer(MinecraftServer pServer) {
        this.server = pServer;
    }

    @Override
    public Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(this.server);
    }
}

