/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network;

import java.util.Optional;
import java.util.TreeSet;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.RecipesWidget;
import top.theillusivec4.polymorph.client.recipe.RecipesWidgetControl;
import top.theillusivec4.polymorph.common.impl.RecipePairImpl;
import top.theillusivec4.polymorph.common.network.PolymorphPackets;

public class PolymorphClientNetwork {
    public static void setup() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.HIGHLIGHT_RECIPE, PolymorphClientNetwork::highlightRecipe);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.RECIPE_SYNC, PolymorphClientNetwork::syncRecipe);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.RECIPES_LIST, PolymorphClientNetwork::sendRecipesList);
    }

    private static void highlightRecipe(class_310 pClient, class_634 pHandler, class_2540 pBuf, PacketSender pSender) {
        class_2960 identifier = pBuf.method_10810();
        pClient.execute(() -> {
            class_746 player = pClient.field_1724;
            if (player != null) {
                RecipesWidgetControl.get().ifPresent(widget -> widget.highlightRecipe(identifier));
            }
        });
    }

    private static void sendRecipesList(class_310 pClient, class_634 pHandler, class_2540 pBuf, PacketSender pSender) {
        TreeSet<RecipePairImpl> recipeDataset = new TreeSet<RecipePairImpl>();
        class_2960 selected = null;
        if (pBuf.isReadable()) {
            int size = pBuf.readInt();
            for (int i = 0; i < size; ++i) {
                recipeDataset.add(new RecipePairImpl(pBuf.method_10810(), pBuf.method_10819()));
            }
            if (pBuf.isReadable()) {
                selected = pBuf.method_10810();
            }
        }
        class_2960 finalSelected = selected;
        pClient.execute(() -> {
            class_746 player = pClient.field_1724;
            if (player != null) {
                Optional<RecipesWidget> maybeWidget = RecipesWidgetControl.get();
                maybeWidget.ifPresent(widget -> widget.setRecipesList(recipeDataset, finalSelected));
                if (!maybeWidget.isPresent()) {
                    RecipesWidgetControl.enqueueRecipesList(recipeDataset, finalSelected);
                }
            }
        });
    }

    private static void syncRecipe(class_310 pClient, class_634 pHandler, class_2540 pBuf, PacketSender pSender) {
        TreeSet<RecipePairImpl> recipeDataset = new TreeSet<RecipePairImpl>();
        class_2960 selected = null;
        if (pBuf.isReadable()) {
            int size = pBuf.readInt();
            for (int i = 0; i < size; ++i) {
                recipeDataset.add(new RecipePairImpl(pBuf.method_10810(), pBuf.method_10819()));
            }
            if (pBuf.isReadable()) {
                selected = pBuf.method_10810();
            }
        }
        class_2960 finalSelected = selected;
        pClient.execute(() -> {
            class_746 player = pClient.field_1724;
            if (player != null) {
                PolymorphApi.common().getRecipeData((class_1657)player).ifPresent(recipeData -> {
                    recipeData.setRecipesList(recipeDataset);
                    player.field_6002.method_8433().method_8130(finalSelected).ifPresent(recipeData::setSelectedRecipe);
                });
            }
        });
    }
}

