/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines;

import com.github.alexnijjar.ad_astra.blocks.machines.entity.AbstractMachineBlockEntity;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.OxygenDistributorBlockEntity;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3619;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class AbstractMachineBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 POWERED = class_2741.field_12484;

    public AbstractMachineBlock(class_4970.class_2251 settings) {
        super(settings.method_9631(AbstractMachineBlock.getLuminance()));
        this.method_9590(this.buildDefaultState());
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (entityWorld, pos, entityState, blockEntity) -> {
            if (blockEntity instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
                machine.tick();
            }
        };
    }

    protected class_2680 buildDefaultState() {
        class_2680 state = (class_2680)this.field_10647.method_11664();
        state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
        if (this.useFacing()) {
            state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)class_2350.field_11043);
        }
        if (this.useLit()) {
            state = (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    protected boolean useFacing() {
        return false;
    }

    protected boolean useLit() {
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)class_25862;
            player.method_17355((class_3908)machineBlock);
        }
        return class_1269.field_5812;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (this.useFacing()) {
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
        }
        return state;
    }

    private static ToIntFunction<class_2680> getLuminance() {
        return blockState -> blockState.method_28498((class_2769)LIT) ? (((Boolean)blockState.method_11654((class_2769)LIT)).booleanValue() ? ((AbstractMachineBlock)blockState.method_26204()).getBrightness() : 0) : 0;
    }

    public int getBrightness() {
        return 12;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            AbstractMachineBlockEntity machineBlock;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof AbstractMachineBlockEntity && (machineBlock = (AbstractMachineBlockEntity)blockEntity).getInventorySize() > 0) {
                if (this.removeOutput()) {
                    machineBlock.method_5441(machineBlock.getInventorySize() - 1);
                }
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)machineBlock);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public boolean removeOutput() {
        return false;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        if (this.useFacing()) {
            builder.method_11667(new class_2769[]{FACING});
        }
        builder.method_11667(new class_2769[]{POWERED});
        if (this.useLit()) {
            builder.method_11667(new class_2769[]{LIT});
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
        return this.useFacing() ? (class_2680)state.method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153()) : state;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean doRedstoneCheck() {
        return true;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        super.method_9612(state, world, pos, block, fromPos, notify);
        if (this.doRedstoneCheck() && !world.field_9236) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(world.method_8479(pos))));
        }
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity instanceof AbstractMachineBlockEntity ? class_1703.method_7608((class_2586)blockEntity) : 0;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)class_25862;
            class_2487 nbt = stack.method_7948();
            class_1262.method_5426((class_2487)nbt, machineBlock.getItems());
            nbt.method_10544("energy", machineBlock.energyStorage.amount);
            if (machineBlock instanceof FluidMachineBlockEntity) {
                FluidMachineBlockEntity fluidMachine = (FluidMachineBlockEntity)machineBlock;
                nbt.method_10566("inputFluid", (class_2520)((FluidVariant)fluidMachine.inputTank.variant).toNbt());
                nbt.method_10544("inputAmount", fluidMachine.inputTank.amount);
                nbt.method_10566("outputFluid", (class_2520)((FluidVariant)fluidMachine.outputTank.variant).toNbt());
                nbt.method_10544("outputAmount", fluidMachine.outputTank.amount);
                if (machineBlock instanceof OxygenDistributorBlockEntity) {
                    OxygenDistributorBlockEntity oxygenDistributorMachine = (OxygenDistributorBlockEntity)machineBlock;
                    nbt.method_10556("showOxygen", oxygenDistributorMachine.shouldShowOxygen());
                }
            }
        }
        return stack;
    }
}

