/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.blocks.machines.AbstractMachineBlock;
import com.github.alexnijjar.ad_astra.util.ModInventory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.SimpleSidedEnergyContainer;

public abstract class AbstractMachineBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ModInventory,
class_1278 {
    private final class_2371<class_1799> inventory;
    public final SimpleSidedEnergyContainer energyStorage = new SimpleSidedEnergyContainer(){

        public long getCapacity() {
            return AbstractMachineBlockEntity.this.getMaxGeneration();
        }

        public long getMaxInsert(@Nullable class_2350 side) {
            return AbstractMachineBlockEntity.this.getMaxEnergyInsert();
        }

        public long getMaxExtract(@Nullable class_2350 side) {
            return AbstractMachineBlockEntity.this.getMaxEnergyExtract();
        }

        protected void onFinalCommit() {
            AbstractMachineBlockEntity.this.method_5431();
        }
    };

    public AbstractMachineBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)this.getInventorySize(), (Object)class_1799.field_8037);
    }

    public abstract void tick();

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return null;
    }

    public boolean usesEnergy() {
        return false;
    }

    public long getMaxGeneration() {
        return 0L;
    }

    public long getEnergyPerTick() {
        return 0L;
    }

    public long getMaxEnergyInsert() {
        return 0L;
    }

    public long getMaxEnergyExtract() {
        return 0L;
    }

    public int getInventorySize() {
        return 0;
    }

    public void setActive(boolean active) {
        if (this.method_11010().method_28498((class_2769)AbstractMachineBlock.LIT)) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)AbstractMachineBlock.LIT, (Comparable)Boolean.valueOf(active)));
        }
    }

    public void cumulateEnergy() {
        if (this.energyStorage.amount < this.getMaxGeneration()) {
            this.energyStorage.amount += this.getEnergyPerTick();
        } else if (this.energyStorage.amount > this.getMaxGeneration()) {
            this.energyStorage.amount = this.getMaxGeneration();
        }
        this.method_5431();
    }

    public boolean drainEnergy() {
        return this.drainEnergy(this.getEnergyPerTick());
    }

    public boolean drainEnergy(long amount) {
        if (!this.field_11863.field_9236) {
            if (this.energyStorage.amount - amount > 0L) {
                this.energyStorage.amount -= amount;
                this.method_5431();
                return true;
            }
            this.energyStorage.amount = 0L;
            this.method_5431();
            return false;
        }
        return false;
    }

    public boolean canDrainEnergy() {
        return this.canDrainEnergy(this.getEnergyPerTick());
    }

    public boolean canDrainEnergy(long amount) {
        return this.energyStorage.amount - amount > 0L;
    }

    public void energyOut() {
        if (this.usesEnergy() && !((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.POWERED)).booleanValue()) {
            for (class_2350 direction : class_2350.values()) {
                EnergyStorageUtil.move((EnergyStorage)this.getSideEnergyStorage(direction), (EnergyStorage)((EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(direction), (Object)direction.method_10153())), (long)Long.MAX_VALUE, null);
            }
        }
    }

    public EnergyStorage getSideEnergyStorage(@Nullable class_2350 side) {
        return this.energyStorage.getSideStorage(side);
    }

    public long getEnergy() {
        return this.energyStorage.amount;
    }

    public boolean hasEnergy() {
        return this.usesEnergy() && this.energyStorage.amount > this.getEnergyPerTick();
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (this.getInventorySize() > 0) {
            class_1262.method_5429((class_2487)nbt, this.inventory);
        }
        if (this.usesEnergy()) {
            this.energyStorage.amount = nbt.method_10537("energy");
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.getInventorySize() > 0) {
            class_1262.method_5426((class_2487)nbt, this.inventory);
        }
        if (this.usesEnergy()) {
            nbt.method_10544("energy", this.energyStorage.amount);
        }
    }

    @Override
    public void method_5431() {
        super.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_14178().method_14128(this.field_11867);
        }
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        class_1799 slotStack = this.method_5438(slot);
        return slotStack.method_7960() || slotStack.method_31574(stack.method_7909()) && slotStack.method_7947() <= slotStack.method_7914();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

