/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.recipes.CryoFuelConversionRecipe;
import com.github.alexnijjar.ad_astra.recipes.ModRecipeType;
import com.github.alexnijjar.ad_astra.registry.ModBlockEntities;
import com.github.alexnijjar.ad_astra.registry.ModRecipes;
import com.github.alexnijjar.ad_astra.screen.handler.CryoFreezerScreenHandler;
import com.github.alexnijjar.ad_astra.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class CryoFreezerBlockEntity
extends FluidMachineBlockEntity {
    protected short cookTime;
    protected short cookTimeTotal;
    @Nullable
    protected class_1792 inputItem;
    @Nullable
    protected class_3611 outputFluid;

    public CryoFreezerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.CRYO_FREEZER, blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cookTime = nbt.method_10568("cookTime");
        this.cookTimeTotal = nbt.method_10568("cookTimeTotal");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("cookTime", this.cookTime);
        nbt.method_10575("cookTimeTotal", this.cookTimeTotal);
    }

    public short getCookTime() {
        return this.cookTime;
    }

    public short getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void finishCooking() {
        CryoFuelConversionRecipe recipe;
        if (this.outputFluid != null && (recipe = this.createRecipe(ModRecipes.CRYO_FUEL_CONVERSION_RECIPE, this.method_5438(0), false)) != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.inputTank.insert((TransferVariant)FluidVariant.of((class_3611)recipe.getFluidOutput()), FluidUtils.millibucketsToDroplets((long)(1000.0 * recipe.getConversionRatio())), (TransactionContext)transaction) > 0L) {
                    transaction.commit();
                }
            }
        }
        this.stopCooking();
    }

    public void stopCooking() {
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.outputFluid = null;
        this.inputItem = null;
        this.method_5431();
    }

    @Override
    public long getInputSize() {
        return AdAstra.CONFIG.cryoFreezer.tankBuckets;
    }

    @Override
    public long getOutputSize() {
        return 0L;
    }

    @Override
    public boolean usesEnergy() {
        return true;
    }

    @Override
    public long getMaxGeneration() {
        return AdAstra.CONFIG.cryoFreezer.maxEnergy;
    }

    @Override
    public long getEnergyPerTick() {
        return AdAstra.CONFIG.cryoFreezer.energyPerTick;
    }

    @Override
    public long getMaxEnergyInsert() {
        return AdAstra.CONFIG.cryoFreezer.energyPerTick * 32L;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 2;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CryoFreezerScreenHandler(syncId, inv, this);
    }

    public CryoFuelConversionRecipe createRecipe(ModRecipeType<CryoFuelConversionRecipe> type, class_1799 testStack, boolean checkOutput) {
        this.stopCooking();
        CryoFuelConversionRecipe recipe = type.findFirst(this.field_11863, f -> f.test(testStack));
        if (recipe != null) {
            if (checkOutput) {
                class_1799 outputSlot = this.method_5438(1);
                class_1799 output = recipe.method_8110();
                if (!outputSlot.method_7960() && !outputSlot.method_7909().equals(recipe.method_8110().method_7909()) || outputSlot.method_7947() + output.method_7947() > outputSlot.method_7914()) {
                    return null;
                }
            }
            this.outputFluid = recipe.getFluidOutput();
            this.inputItem = testStack.method_7909();
        }
        return recipe;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            class_1799 input = this.method_5438(0);
            class_1799 outputInsertSlot = this.method_5438(1);
            class_1799 outputExtractSlot = this.method_5438(2);
            if (!outputInsertSlot.method_7960() && outputExtractSlot.method_7947() < outputExtractSlot.method_7914()) {
                FluidUtils.extractFluidFromTank(this, (Storage<FluidVariant>)this.inputTank, 1, 2);
            }
            if (this.hasEnergy()) {
                if (!input.method_7960() && (input.method_7909().equals(this.inputItem) || this.inputItem == null) && this.inputTank.getAmount() < this.inputTank.getCapacity()) {
                    this.setActive(true);
                    if (this.cookTime < this.cookTimeTotal) {
                        this.cookTime = (short)(this.cookTime + 1);
                        this.drainEnergy();
                    } else if (this.outputFluid != null) {
                        this.finishCooking();
                        input.method_7934(1);
                    } else {
                        CryoFuelConversionRecipe recipe = this.createRecipe(ModRecipes.CRYO_FUEL_CONVERSION_RECIPE, input, false);
                        if (recipe != null) {
                            this.cookTimeTotal = (short)25;
                            this.cookTime = 0;
                        }
                    }
                } else if (this.outputFluid != null) {
                    this.stopCooking();
                } else {
                    this.setActive(false);
                }
            }
        }
    }
}

