/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.machines.AbstractMachineBlock;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.recipes.OxygenConversionRecipe;
import com.github.alexnijjar.ad_astra.registry.ModBlockEntities;
import com.github.alexnijjar.ad_astra.registry.ModParticleTypes;
import com.github.alexnijjar.ad_astra.registry.ModRecipes;
import com.github.alexnijjar.ad_astra.screen.handler.OxygenDistributorScreenHandler;
import com.github.alexnijjar.ad_astra.util.FluidUtils;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import com.github.alexnijjar.ad_astra.util.algorithms.OxygenFillerAlgorithm;
import com.github.alexnijjar.ad_astra.util.entity.OxygenUtils;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlockEntity
extends FluidMachineBlockEntity {
    private int oxygenFillCheckTicks;
    private boolean showOxygen;

    public OxygenDistributorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.OXYGEN_DISTRIBUTOR, blockPos, blockState);
        this.oxygenFillCheckTicks = AdAstra.CONFIG.oxygenDistributor.refreshTicks;
        this.showOxygen = false;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.showOxygen = nbt.method_10577("showOxygen");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("showOxygen", this.showOxygen);
    }

    public boolean shouldShowOxygen() {
        return this.showOxygen;
    }

    public void setShowOxygen(boolean value) {
        this.showOxygen = value;
    }

    @Override
    public long getInputSize() {
        return AdAstra.CONFIG.oxygenDistributor.tankBuckets;
    }

    @Override
    public long getOutputSize() {
        return AdAstra.CONFIG.oxygenDistributor.tankBuckets * 2;
    }

    @Override
    public boolean usesEnergy() {
        return true;
    }

    @Override
    public long getMaxGeneration() {
        return AdAstra.CONFIG.oxygenDistributor.maxEnergy;
    }

    @Override
    public long getEnergyPerTick() {
        return AdAstra.CONFIG.oxygenDistributor.fluidConversionEnergyPerTick;
    }

    @Override
    public long getMaxEnergyInsert() {
        return AdAstra.CONFIG.oxygenDistributor.fluidConversionEnergyPerTick * 512L;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new OxygenDistributorScreenHandler(syncId, inv, this);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public int getMaxBlockChecks() {
        return AdAstra.CONFIG.oxygenDistributor.maxBlockChecks;
    }

    public long getFluidToExtract(long oxygenBlocks, boolean client) {
        long value = (long)((double)oxygenBlocks * AdAstra.CONFIG.oxygenDistributor.oxygenMultiplier / 40.0);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public long getEnergyToConsume(long oxygenBlocks, boolean client) {
        long value = (long)((double)oxygenBlocks * AdAstra.CONFIG.oxygenDistributor.energyMultiplier / 75.0);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public void extractResources() {
        long oxygenBlocks = OxygenUtils.getOxygenBlocksCount(this.field_11863, this.method_11016());
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        try (Transaction transaction = Transaction.openOuter();){
            if (!((FluidVariant)this.outputTank.variant).isBlank()) {
                if (this.outputTank.extract((TransferVariant)((FluidVariant)this.outputTank.getResource()), amountOfFluidToExtract, (TransactionContext)transaction) != amountOfFluidToExtract) {
                    this.outputTank.amount = 0L;
                }
                transaction.commit();
            }
        }
        if (this.drainEnergy(amountOfEnergyToConsume)) {
            ModUtils.spawnForcedParticles((class_3218)this.field_11863, ModParticleTypes.OXYGEN_BUBBLE, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.03);
        }
    }

    public boolean canDistribute(int oxygenBlocks) {
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        if (this.outputTank.isResourceBlank()) {
            return false;
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.POWERED)).booleanValue()) {
            return false;
        }
        if (!this.canDrainEnergy(amountOfEnergyToConsume)) {
            return false;
        }
        if (((FluidVariant)this.outputTank.variant).isBlank()) {
            return false;
        }
        return this.outputTank.simulateExtract((Object)((FluidVariant)this.outputTank.getResource()), amountOfFluidToExtract, null) == amountOfFluidToExtract;
    }

    @Override
    public void tick() {
        super.tick();
        class_1799 insertSlot = (class_1799)this.getItems().get(0);
        class_1799 extractSlot = (class_1799)this.getItems().get(1);
        if (!this.field_11863.field_9236) {
            List<OxygenConversionRecipe> recipes;
            if (!insertSlot.method_7960() && extractSlot.method_7947() < extractSlot.method_7914()) {
                ModRecipes.OXYGEN_CONVERSION_RECIPE.getRecipes(this.field_11863);
                FluidUtils.insertFluidIntoTank(this, (Storage<FluidVariant>)this.inputTank, 0, 1, f -> ModRecipes.OXYGEN_CONVERSION_RECIPE.getRecipes(this.field_11863).stream().anyMatch(r -> r.getFluidInput().equals(f.getFluid())));
            }
            if (this.canDrainEnergy() && FluidUtils.convertFluid(this, recipes = ModRecipes.OXYGEN_CONVERSION_RECIPE.getRecipes(this.field_11863), 50)) {
                this.drainEnergy();
            }
        }
        if (this.oxygenFillCheckTicks >= AdAstra.CONFIG.oxygenDistributor.refreshTicks) {
            this.runAlgorithm();
            this.oxygenFillCheckTicks = 0;
        } else {
            ++this.oxygenFillCheckTicks;
        }
        if (!this.field_11863.field_9236) {
            boolean active = OxygenUtils.getOxygenBlocksCount(this.field_11863, this.method_11016()) > 0;
            this.setActive(active);
            if (active) {
                this.extractResources();
            }
        }
    }

    public void runAlgorithm() {
        if (this.field_11863.field_9236 ? (Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.LIT) == false : this.outputTank.amount <= 0L && this.energyStorage.amount <= 0L) {
            return;
        }
        OxygenFillerAlgorithm floodFiller = new OxygenFillerAlgorithm(this.field_11863, this.getMaxBlockChecks());
        Set<class_2338> positions = floodFiller.runAlgorithm(this.field_11867.method_10084());
        if (this.canDistribute(positions.size())) {
            OxygenUtils.setEntry(this.field_11863, this.field_11867, positions);
        } else if (!this.field_11863.field_9236) {
            OxygenUtils.removeEntry(this.field_11863, this.method_11016());
        }
        if (this.shouldShowOxygen()) {
            this.spawnParticles(positions);
        }
    }

    public void spawnParticles(Set<class_2338> positions) {
        if (!this.field_11863.field_9236 && ((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.LIT)).booleanValue()) {
            for (class_2338 pos : positions) {
                ModUtils.spawnForcedParticles((class_3218)this.method_10997(), ModParticleTypes.OXYGEN_BUBBLE, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

