/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.blocks.machines.entity.AbstractMachineBlockEntity;
import com.github.alexnijjar.ad_astra.recipes.CookingRecipe;
import com.github.alexnijjar.ad_astra.recipes.ModRecipeType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessingMachineBlockEntity
extends AbstractMachineBlockEntity {
    protected short cookTime;
    protected short cookTimeTotal;
    @Nullable
    protected class_1792 inputItem;
    @Nullable
    protected class_1799 outputStack;

    public ProcessingMachineBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public boolean usesEnergy() {
        return true;
    }

    @Override
    public abstract long getMaxGeneration();

    @Override
    public abstract long getEnergyPerTick();

    @Override
    public abstract int getInventorySize();

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cookTime = nbt.method_10568("cookTime");
        this.cookTimeTotal = nbt.method_10568("cookTimeTotal");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("cookTime", this.cookTime);
        nbt.method_10575("cookTimeTotal", this.cookTimeTotal);
    }

    public short getCookTime() {
        return this.cookTime;
    }

    public short getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void finishCooking() {
        if (this.outputStack != null) {
            int size = this.outputStack.method_7947() + this.method_5438(1).method_7947();
            this.method_5447(1, new class_1799((class_1935)this.outputStack.method_7909(), size));
        }
        this.stopCooking();
    }

    public void stopCooking() {
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.outputStack = null;
        this.inputItem = null;
        this.method_5431();
    }

    public <T extends CookingRecipe> CookingRecipe createRecipe(ModRecipeType<T> type, class_1799 testStack, boolean checkOutput) {
        this.stopCooking();
        CookingRecipe recipe = type.findFirst(this.field_11863, f -> f.test(testStack));
        if (recipe != null) {
            if (checkOutput) {
                class_1799 outputSlot = this.method_5438(1);
                class_1799 output = recipe.method_8110();
                if (!outputSlot.method_7960() && !outputSlot.method_7909().equals(recipe.method_8110().method_7909()) || outputSlot.method_7947() + output.method_7947() > outputSlot.method_7914()) {
                    return null;
                }
            }
            this.outputStack = recipe.method_8110();
            this.inputItem = testStack.method_7909();
        }
        return recipe;
    }
}

