/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.machines.AbstractMachineBlock;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.registry.ModBlockEntities;
import com.github.alexnijjar.ad_astra.registry.ModParticleTypes;
import com.github.alexnijjar.ad_astra.screen.handler.WaterPumpScreenHandler;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public class WaterPumpBlockEntity
extends FluidMachineBlockEntity {
    public static final class_2350[] INSERT_DIRECTIONS = new class_2350[]{class_2350.field_11036, class_2350.field_11035};
    private long waterExtracted;

    public WaterPumpBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.WATER_PUMP, blockPos, blockState);
    }

    @Override
    public long getInputSize() {
        return AdAstra.CONFIG.waterPump.tankBuckets;
    }

    @Override
    public long getOutputSize() {
        return 0L;
    }

    @Override
    public boolean usesEnergy() {
        return true;
    }

    @Override
    public long getMaxGeneration() {
        return AdAstra.CONFIG.waterPump.maxEnergy;
    }

    @Override
    public long getEnergyPerTick() {
        return AdAstra.CONFIG.waterPump.energyPerTick;
    }

    @Override
    public long getMaxEnergyInsert() {
        return AdAstra.CONFIG.waterPump.energyPerTick * 32L;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new WaterPumpScreenHandler(syncId, inv, this);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.waterExtracted = nbt.method_10537("waterExtracted");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("waterExtracted", this.waterExtracted);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            FluidVariant waterFluid = FluidVariant.of((class_3611)class_3612.field_15910);
            class_2680 water = this.field_11863.method_8320(this.method_11016().method_10074());
            if (this.inputTank.getAmount() < this.inputTank.getCapacity()) {
                if (water.method_27852(class_2246.field_10382) && (Integer)water.method_11654((class_2769)class_2404.field_11278) == 0) {
                    if (!((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.POWERED)).booleanValue() && this.hasEnergy()) {
                        this.setActive(true);
                        ModUtils.spawnForcedParticles((class_3218)this.field_11863, ModParticleTypes.OXYGEN_BUBBLE, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() - 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                        this.drainEnergy();
                        this.waterExtracted += AdAstra.CONFIG.waterPump.transferPerTick;
                        try (Transaction transaction = Transaction.openOuter();){
                            this.inputTank.insert((TransferVariant)waterFluid, AdAstra.CONFIG.waterPump.transferPerTick, (TransactionContext)transaction);
                            transaction.commit();
                        }
                    } else {
                        this.setActive(false);
                    }
                    if (AdAstra.CONFIG.waterPump.deleteWaterBelowWaterPump && this.waterExtracted >= 81000L) {
                        this.waterExtracted = 0L;
                        this.field_11863.method_8501(this.method_11016().method_10074(), class_2246.field_10124.method_9564());
                    }
                }
            } else {
                this.setActive(false);
            }
            if (this.hasEnergy()) {
                if (this.outputTank.amount < this.outputTank.getCapacity()) {
                    this.drainEnergy();
                }
                for (class_2350 direction : new class_2350[]{class_2350.field_11036, (class_2350)this.method_11010().method_11654((class_2769)AbstractMachineBlock.FACING)}) {
                    Storage storage = (Storage)FluidStorage.SIDED.find(this.field_11863, this.method_11016().method_10093(direction), (Object)direction);
                    if (storage == null) continue;
                    try (Transaction transaction = Transaction.openOuter();){
                        long transferPerTick = AdAstra.CONFIG.waterPump.transferPerTick;
                        if (this.inputTank.extract((TransferVariant)waterFluid, transferPerTick, (TransactionContext)transaction) != transferPerTick || storage.insert((Object)waterFluid, transferPerTick, (TransactionContext)transaction) != transferPerTick) continue;
                        transaction.commit();
                    }
                }
            }
        }
    }
}

