/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.pipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public interface InteractablePipe<T> {
    public boolean supportsAutoExtract();

    public boolean canTakeFrom(T var1);

    public boolean canInsertInto(T var1);

    public boolean canConnectTo(class_2586 var1, class_2350 var2, class_2338 var3);

    public void insertInto(T var1, class_2350 var2, class_2338 var3);

    public T getInteraction(class_1937 var1, class_2338 var2, class_2350 var3);

    public Node<T> getSource();

    public void setSource(Node<T> var1);

    public void clearSource();

    public List<Node<T>> getConsumers();

    public class_1937 getPipeWorld();

    public class_2338 getPipePos();

    public int getWorkTime();

    public long getTransferAmount();

    default public void handleSourceFinding() {
    }

    /*
     * WARNING - void declaration
     */
    default public void pipeTick() {
        block11: {
            block12: {
                if (this.getPipeWorld().method_8608()) break block11;
                if (this.getPipeWorld().method_8510() % (long)this.getWorkTime() != 0L) break block12;
                this.clearSource();
                this.getConsumers().clear();
                HashSet<class_2338> visitedNodes = new HashSet<class_2338>();
                HashSet<Object> availableNodes = new HashSet<Object>();
                if (this.supportsAutoExtract()) {
                    void var5_9;
                    availableNodes.add(this.getPipePos());
                    class_2350[] class_2350Array = class_2350.values();
                    int n = class_2350Array.length;
                    boolean bl = false;
                    while (var5_9 < n) {
                        class_2350 direction = class_2350Array[var5_9];
                        class_2338 offset = this.getPipePos().method_10093(direction);
                        T potentialSource = this.getInteraction(this.getPipeWorld(), offset, direction);
                        if (potentialSource != null && this.canTakeFrom(potentialSource)) {
                            this.setSource(new Node<T>(potentialSource, direction, offset));
                            break;
                        }
                        ++var5_9;
                    }
                } else {
                    this.handleSourceFinding();
                }
                if (this.getSource() == null) break block11;
                while (!availableNodes.isEmpty()) {
                    ArrayList<class_2338> temporaryOpenNodes = new ArrayList<class_2338>();
                    for (class_2338 class_23382 : availableNodes) {
                        class_2586 current = this.getPipeWorld().method_8321(class_23382);
                        for (class_2350 direction : class_2350.values()) {
                            class_2338 offset = class_23382.method_10093(direction);
                            class_2586 entity = this.getPipeWorld().method_8321(offset);
                            if (!visitedNodes.contains(offset) && entity instanceof InteractablePipe) {
                                InteractablePipe pipe = (InteractablePipe)entity;
                                if (!pipe.canConnectTo(current, direction, offset)) continue;
                                temporaryOpenNodes.add(offset);
                                continue;
                            }
                            T potentialConsumer = this.getInteraction(this.getPipeWorld(), offset, direction);
                            if (potentialConsumer == null || !this.canInsertInto(potentialConsumer)) continue;
                            this.getConsumers().add(new Node<T>(potentialConsumer, direction, class_23382));
                        }
                        visitedNodes.add(class_23382);
                    }
                    availableNodes.clear();
                    availableNodes.addAll(temporaryOpenNodes);
                }
                break block11;
            }
            if (this.getSource() != null && !this.getConsumers().isEmpty()) {
                for (Node<T> consumer : this.getConsumers()) {
                    this.insertInto(consumer.storage(), consumer.direction(), consumer.pos());
                }
            }
        }
    }

    public record Node<T>(T storage, class_2350 direction, class_2338 pos) {
    }
}

