/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.registry;

import com.github.alexnijjar.ad_astra.client.AdAstraClient;
import com.github.alexnijjar.ad_astra.client.renderer.sky.ModSky;
import com.github.alexnijjar.ad_astra.client.renderer.sky.cloud_renderer.ModCloudRenderer;
import com.github.alexnijjar.ad_astra.client.renderer.sky.dimension_effects.ModDimensionEffects;
import com.github.alexnijjar.ad_astra.client.renderer.sky.weather_renderer.ModWeatherRenderer;
import com.github.alexnijjar.ad_astra.client.resourcepack.SkyRenderer;
import com.github.alexnijjar.ad_astra.util.ColourHolder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5294;

@Environment(value=EnvType.CLIENT)
public class ClientModSkies {
    public static void register() {
        for (final SkyRenderer skyRenderer : AdAstraClient.skyRenderers) {
            ModSky sky = new ModSky();
            sky.setStars(skyRenderer.starsRenderer());
            sky.setSunsetColour(skyRenderer.sunsetColour());
            sky.setSkyObjects(skyRenderer.skyObjects());
            sky.setHorizonAngle(skyRenderer.horizonAngle());
            sky.disableRenderingWhileRaining(!skyRenderer.weatherEffects().equals((Object)SkyRenderer.WeatherEffects.NONE));
            DimensionRenderingRegistry.registerSkyRenderer(skyRenderer.dimension(), (DimensionRenderingRegistry.SkyRenderer)sky);
            switch (skyRenderer.effects().type()) {
                case SIMPLE: {
                    DimensionRenderingRegistry.registerDimensionEffects((class_2960)skyRenderer.dimension().method_29177(), (class_5294)new ModDimensionEffects());
                    break;
                }
                case NONE: {
                    DimensionRenderingRegistry.registerDimensionEffects((class_2960)skyRenderer.dimension().method_29177(), (class_5294)new ModDimensionEffects(){

                        public float[] method_28109(float skyAngle, float tickDelta) {
                            return null;
                        }
                    });
                    break;
                }
                case FOGGY_REVERSED: {
                    DimensionRenderingRegistry.registerDimensionEffects((class_2960)skyRenderer.dimension().method_29177(), (class_5294)new ModDimensionEffects(){

                        @Override
                        public boolean method_28110(int camX, int camY) {
                            return true;
                        }

                        public float[] method_28109(float skyAngle, float tickDelta) {
                            return null;
                        }
                    });
                    break;
                }
                case FOGGY: {
                    DimensionRenderingRegistry.registerDimensionEffects((class_2960)skyRenderer.dimension().method_29177(), (class_5294)new ModDimensionEffects(){

                        @Override
                        public boolean method_28110(int camX, int camY) {
                            return true;
                        }
                    });
                    break;
                }
                case COLORED_HORIZON: {
                    DimensionRenderingRegistry.registerDimensionEffects((class_2960)skyRenderer.dimension().method_29177(), (class_5294)new ModDimensionEffects(){

                        @Override
                        public class_243 method_28112(class_243 color, float sunHeight) {
                            return ColourHolder.toVector(skyRenderer.effects().colour());
                        }
                    });
                }
            }
            switch (skyRenderer.cloudEffects()) {
                case NONE: {
                    DimensionRenderingRegistry.registerCloudRenderer(skyRenderer.dimension(), (DimensionRenderingRegistry.CloudRenderer)new DimensionRenderingRegistry.CloudRenderer(){

                        public void render(WorldRenderContext context) {
                        }
                    });
                    break;
                }
                case VANILLA: {
                    break;
                }
                case VENUS: {
                    DimensionRenderingRegistry.registerCloudRenderer(skyRenderer.dimension(), (DimensionRenderingRegistry.CloudRenderer)new ModCloudRenderer().withVenus());
                }
            }
            switch (skyRenderer.weatherEffects()) {
                case NONE: {
                    break;
                }
                case VENUS: {
                    DimensionRenderingRegistry.registerWeatherRenderer(skyRenderer.dimension(), (DimensionRenderingRegistry.WeatherRenderer)new ModWeatherRenderer().withVenus());
                }
            }
        }
    }
}

