/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.block.flag;

import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FlagTexture
extends class_1049 {
    private static final HttpClient CLIENT = HttpClient.newBuilder().build();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 DEFAULT_FLAG = new ModIdentifier("textures/block/flag/warning_flag.png");
    private final HttpRequest request;
    private boolean loaded;
    private CompletableFuture<?> loader;

    public FlagTexture(String url) {
        super(DEFAULT_FLAG);
        this.request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Ad Astra (Minecraft Mod)").build();
    }

    public static class_2960 getTextureId(String url) {
        return new ModIdentifier("flagtextures/" + Hashing.sha1().hashUnencodedChars((CharSequence)url));
    }

    private void upload(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
    }

    public void method_4625(class_3300 manager) {
        class_310.method_1551().execute(() -> {
            if (!this.loaded) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.field_5224, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            this.loader = CompletableFuture.runAsync(() -> {
                try {
                    HttpResponse<InputStream> data = CLIENT.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
                    if (data.statusCode() / 100 == 2) {
                        class_1011 image = this.loadTexture(data.body());
                        class_310.method_1551().execute(() -> {
                            if (image != null) {
                                class_310.method_1551().execute(() -> {
                                    this.loaded = true;
                                    if (!RenderSystem.isOnRenderThread()) {
                                        RenderSystem.recordRenderCall(() -> this.upload(image));
                                    } else {
                                        this.upload(image);
                                    }
                                });
                            }
                        });
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("Couldn't download http texture", (Throwable)e);
                }
            }, class_156.method_18349());
        }
    }

    @Nullable
    private class_1011 loadTexture(InputStream stream) {
        class_1011 nativeImage = null;
        try {
            nativeImage = class_1011.method_4309((InputStream)stream);
        }
        catch (Exception var4) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)var4);
        }
        return nativeImage;
    }
}

