/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.sky;

import com.github.alexnijjar.ad_astra.client.renderer.sky.SkyUtil;
import com.github.alexnijjar.ad_astra.client.resourcepack.SkyRenderer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1160;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5365;

@Environment(value=EnvType.CLIENT)
public class ModSky
implements DimensionRenderingRegistry.SkyRenderer {
    protected class_291 starsBuffer;
    protected float skyAngle;
    private SkyRenderer.StarsRenderer starsRenderer;
    private SkyRenderer.SunsetColour sunsetColour;
    private List<SkyRenderer.SkyObject> skyObjects;
    private int horizonAngle;
    private boolean shouldRenderWhileRaining;

    public void render(WorldRenderContext context) {
        this.skyAngle = context.world().method_30274(context.tickDelta());
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_310 client = class_310.method_1551();
        if (this.shouldRenderWhileRaining && client.field_1687.method_8419()) {
            return;
        }
        if (SkyUtil.isSubmerged(context.camera())) {
            return;
        }
        SkyUtil.preRender(context, bufferBuilder, this.sunsetColour, this.horizonAngle, context.matrixStack(), context.world(), context.tickDelta());
        if (this.starsRenderer.fastStars() > 0) {
            int stars = context.advancedTranslucency() || client.field_1690.field_25444.equals((Object)class_5365.field_25428) ? this.starsRenderer.fancyStars() : this.starsRenderer.fastStars();
            this.starsBuffer = SkyUtil.renderStars(context, bufferBuilder, this.starsBuffer, stars, this.starsRenderer);
        }
        for (SkyRenderer.SkyObject skyObject : this.skyObjects) {
            float scale = skyObject.scale();
            class_1160 rotation = skyObject.rotation();
            switch (skyObject.renderType()) {
                case STATIC: {
                    break;
                }
                case DYNAMIC: {
                    rotation = new class_1160(this.skyAngle * 360.0f + rotation.method_4943(), rotation.method_4945(), rotation.method_4947());
                    break;
                }
                case SCALING: {
                    scale *= SkyUtil.getScale();
                    break;
                }
                case DEBUG: {
                    rotation = new class_1160(60.0f, 0.0f, 0.0f);
                }
            }
            SkyUtil.render(context, bufferBuilder, skyObject.texture(), skyObject.colour(), rotation, scale, skyObject.blending());
        }
        SkyUtil.postRender(context, context.matrixStack(), context.world(), context.tickDelta());
    }

    public void setStars(SkyRenderer.StarsRenderer starsRenderer) {
        this.starsRenderer = starsRenderer;
    }

    public void setSunsetColour(SkyRenderer.SunsetColour sunsetColour) {
        this.sunsetColour = sunsetColour;
    }

    public void setHorizonAngle(int horizonAngle) {
        this.horizonAngle = horizonAngle;
    }

    public void setSkyObjects(List<SkyRenderer.SkyObject> skyObjects) {
        this.skyObjects = skyObjects;
    }

    public void disableRenderingWhileRaining(boolean value) {
        this.shouldRenderWhileRaining = value;
    }

    public static float[] getMarsColour(float skyAngle) {
        float[] colours = new float[4];
        float cosine = class_3532.method_15362((float)(skyAngle * ((float)Math.PI * 2))) - 0.0f;
        if (cosine >= -0.4f && cosine <= 0.4f) {
            float c = (cosine + 0.0f) / 0.4f * 0.5f + 0.5f;
            float sine = 1.0f - (1.0f - class_3532.method_15374((float)(c * (float)Math.PI))) * 0.99f;
            sine *= sine;
            colours[0] = c * 0.3f;
            colours[1] = c * c * 0.6f + 0.55f;
            colours[2] = c * c * 0.0f + 0.8f;
            colours[3] = sine;
            return colours;
        }
        return null;
    }
}

