/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.sky.cloud_renderer;

import com.github.alexnijjar.ad_astra.mixin.client.WorldRendererAccessor;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_758;

@Environment(value=EnvType.CLIENT)
public class ModCloudRenderer
implements DimensionRenderingRegistry.CloudRenderer {
    private static final class_2960 VENUS_CLOUD_TEXTURE = new ModIdentifier("textures/sky/venus/clouds.png");
    private class_2960 texture;

    public ModCloudRenderer withVenus() {
        this.texture = VENUS_CLOUD_TEXTURE;
        return this;
    }

    public void render(WorldRenderContext context) {
        class_243 cameraPos = context.camera().method_19326();
        double cameraPosX = cameraPos.method_10216();
        double cameraPosY = cameraPos.method_10214();
        double cameraPosZ = cameraPos.method_10215();
        WorldRendererAccessor renderer = (WorldRendererAccessor)context.worldRenderer();
        class_4587 matrices = context.matrixStack();
        float tickDelta = context.tickDelta();
        class_310 client = class_310.method_1551();
        float g = context.world().method_28103().method_28108();
        if (!Float.isNaN(g)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            double k = ((float)renderer.getTicks() + tickDelta) * 0.03f;
            double l = (cameraPosX + k) / 12.0;
            double m = g - (float)cameraPosY + 0.33f;
            double n = cameraPosZ / 12.0 + (double)0.33f;
            l -= (double)(class_3532.method_15357((double)(l / 2048.0)) * 2048);
            n -= (double)(class_3532.method_15357((double)(n / 2048.0)) * 2048);
            float o = (float)(l - (double)class_3532.method_15357((double)l));
            float p = (float)(m / 4.0 - (double)class_3532.method_15357((double)(m / 4.0))) * 4.0f;
            float q = (float)(n - (double)class_3532.method_15357((double)n));
            class_243 colour = context.world().method_23785(tickDelta);
            int r = (int)Math.floor(l);
            int s = (int)Math.floor(m / 4.0);
            int t = (int)Math.floor(n);
            if (r != renderer.getLastCloudsBlockX() || s != renderer.getLastCloudsBlockY() || t != renderer.getLastCloudsBlockZ() || client.field_1690.method_1632() != renderer.getLastCloudsRenderMode() || renderer.getLastCloudsColor().method_1025(colour) > 2.0E-4) {
                renderer.setLastCloudsBlockX(r);
                renderer.setLastCloudsBlockY(s);
                renderer.setLastCloudsBlockZ(t);
                renderer.setLastCloudsColor(colour);
                renderer.setLastCloudsRenderMode(client.field_1690.method_1632());
                renderer.setCloudsDirty(true);
            }
            if (renderer.getCloudsDirty()) {
                renderer.setCloudsDirty(false);
                class_287 bufferBuilder = class_289.method_1348().method_1349();
                if (renderer.getCloudsBuffer() != null) {
                    renderer.getCloudsBuffer().close();
                }
                renderer.setCloudsBuffer(new class_291());
                renderer.invokeRenderClouds(bufferBuilder, l, m, n, colour);
                bufferBuilder.method_1326();
                renderer.getCloudsBuffer().method_1352(bufferBuilder);
            }
            RenderSystem.setShader(class_757::method_34549);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            class_758.method_3212();
            matrices.method_22903();
            matrices.method_22905(12.0f, 1.0f, 12.0f);
            matrices.method_22904((double)(-o), (double)p, (double)(-q));
            if (renderer.getCloudsBuffer() != null) {
                int u;
                for (int v = u = renderer.getLastCloudsRenderMode() == class_4063.field_18164 ? 0 : 1; v < 2; ++v) {
                    if (v == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    class_5944 shader = RenderSystem.getShader();
                    renderer.getCloudsBuffer().method_34427(matrices.method_23760().method_23761(), context.projectionMatrix(), shader);
                }
            }
            matrices.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }
}

