/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.resourcepack;

import com.github.alexnijjar.ad_astra.client.resourcepack.SolarSystem;
import com.github.alexnijjar.ad_astra.data.ButtonColour;
import com.github.alexnijjar.ad_astra.util.ColourHolder;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class SolarSystemParser {
    public static SolarSystem parse(JsonObject jsonObject) {
        class_2960 galaxy = new class_2960(jsonObject.get("galaxy").getAsString());
        class_2960 solarSystem = new class_2960(jsonObject.get("solar_system").getAsString());
        class_2960 sun = new class_2960(jsonObject.get("sun").getAsString());
        int sunScale = jsonObject.get("sun_scale").getAsInt();
        ButtonColour buttonColour = ButtonColour.stringToColour(jsonObject.get("button_color").getAsString());
        JsonObject ringColours = jsonObject.get("ring_color").getAsJsonObject();
        int ringR = ringColours.get("r").getAsInt();
        int ringG = ringColours.get("g").getAsInt();
        int ringB = ringColours.get("b").getAsInt();
        int ringA = ringColours.get("a").getAsInt();
        return new SolarSystem(galaxy, solarSystem, sun, sunScale, buttonColour, new ColourHolder(ringR, ringG, ringB, ringA));
    }
}

