/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.screens;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.OxygenDistributorBlockEntity;
import com.github.alexnijjar.ad_astra.client.screens.AbstractMachineScreen;
import com.github.alexnijjar.ad_astra.client.screens.GuiUtil;
import com.github.alexnijjar.ad_astra.client.screens.utils.ButtonType;
import com.github.alexnijjar.ad_astra.client.screens.utils.CustomButton;
import com.github.alexnijjar.ad_astra.client.screens.utils.PlanetSelectionScreen;
import com.github.alexnijjar.ad_astra.client.screens.utils.ScreenUtils;
import com.github.alexnijjar.ad_astra.data.ButtonColour;
import com.github.alexnijjar.ad_astra.networking.ModC2SPackets;
import com.github.alexnijjar.ad_astra.screen.handler.OxygenDistributorScreenHandler;
import com.github.alexnijjar.ad_astra.util.FluidUtils;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.github.alexnijjar.ad_astra.util.entity.OxygenUtils;
import java.awt.Rectangle;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class OxygenDistributorScreen
extends AbstractMachineScreen<OxygenDistributorScreenHandler> {
    private static final class_2960 TEXTURE = new ModIdentifier("textures/gui/screens/oxygen_distributor.png");
    private static final class_2960 WARNING_SIGN = new ModIdentifier("textures/gui/overlay/warning_sign.png");
    class_2561 SHOW_TEXT = ScreenUtils.createText("show");
    class_2561 HIDE_TEXT = ScreenUtils.createText("hide");
    public static final int INPUT_TANK_LEFT = 50;
    public static final int INPUT_TANK_TOP = 80;
    public static final int OUTPUT_TANK_LEFT = 114;
    public static final int OUTPUT_TANK_TOP = 80;
    public static final int ENERGY_LEFT = 147;
    public static final int ENERGY_TOP = 82;
    private boolean displayConversionEnergyCost = false;
    CustomButton visibleButton;

    public OxygenDistributorScreen(OxygenDistributorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title, TEXTURE);
        this.field_2792 = 177;
        this.field_2779 = 244;
        this.field_25270 = this.field_2779 - 92;
        this.field_25268 = 67;
    }

    @Override
    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        boolean oxygenLeak;
        super.method_2389(matrices, delta, mouseX, mouseY);
        FluidMachineBlockEntity entity = (FluidMachineBlockEntity)this.blockEntity;
        GuiUtil.drawEnergy(matrices, this.field_2776 + 147, this.field_2800 + 82, this.blockEntity.getEnergy(), this.blockEntity.getMaxGeneration());
        GuiUtil.drawFluidTank(matrices, this.field_2776 + 50, this.field_2800 + 80, entity.inputTank.getAmount(), entity.inputTank.getCapacity(), (FluidVariant)entity.inputTank.getResource());
        GuiUtil.drawFluidTank(matrices, this.field_2776 + 114, this.field_2800 + 80, entity.outputTank.getAmount(), entity.outputTank.getCapacity(), (FluidVariant)entity.outputTank.getResource());
        this.visibleButton.method_25355(((OxygenDistributorBlockEntity)this.blockEntity).shouldShowOxygen() ? this.HIDE_TEXT : this.SHOW_TEXT);
        boolean bl = oxygenLeak = OxygenUtils.getOxygenBlocksCount(this.blockEntity.method_10997(), this.blockEntity.method_11016()) >= AdAstra.CONFIG.oxygenDistributor.maxBlockChecks;
        if (oxygenLeak) {
            ScreenUtils.addTexture(matrices, this.field_22789 / 2 - 85, this.field_22790 / 2 - 137, 14, 15, WARNING_SIGN);
        }
        if (OxygenUtils.getOxygenBlocksCount(this.blockEntity.method_10997(), this.blockEntity.method_11016()) <= 0 && entity.hasEnergy() && entity.outputTank.amount > 0L) {
            ScreenUtils.addTexture(matrices, this.field_22789 / 2 - 67, this.field_22790 / 2 - 137, 14, 15, WARNING_SIGN);
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean oxygenLeak;
        super.method_25394(matrices, mouseX, mouseY, delta);
        FluidMachineBlockEntity entity = (FluidMachineBlockEntity)this.blockEntity;
        if (GuiUtil.isHovering(this.getEnergyBounds(), mouseX, mouseY)) {
            GuiUtil.drawEnergyTooltip((class_437)this, matrices, entity, mouseX, mouseY);
        }
        if (GuiUtil.isHovering(this.getInputTankBounds(), mouseX, mouseY)) {
            GuiUtil.drawTankTooltip((class_437)this, matrices, entity.inputTank, mouseX, mouseY);
        }
        if (GuiUtil.isHovering(this.getOutputTankBounds(), mouseX, mouseY)) {
            GuiUtil.drawTankTooltip((class_437)this, matrices, entity.outputTank, mouseX, mouseY);
        }
        int oxygenBlocksCount = OxygenUtils.getOxygenBlocksCount(this.blockEntity.method_10997(), this.blockEntity.method_11016());
        boolean bl = oxygenLeak = OxygenUtils.getOxygenBlocksCount(this.blockEntity.method_10997(), this.blockEntity.method_11016()) >= AdAstra.CONFIG.oxygenDistributor.maxBlockChecks;
        if (oxygenLeak && GuiUtil.isHovering(this.getOxygenLeakWarningSignBounds(), mouseX, mouseY)) {
            this.method_30901(matrices, Arrays.asList(new class_2588("gauge_text.ad_astra.oxygen_leak_warning[0]"), new class_2588("gauge_text.ad_astra.oxygen_leak_warning[1]"), new class_2588("gauge_text.ad_astra.oxygen_leak_warning[2]"), new class_2588("gauge_text.ad_astra.oxygen_leak_warning[3]"), new class_2588("gauge_text.ad_astra.oxygen_leak_warning[4]")), mouseX, mouseY);
        }
        if (oxygenBlocksCount <= 0 && entity.hasEnergy() && entity.outputTank.amount > 0L && GuiUtil.isHovering(this.getBlockedWarningSignBounds(), mouseX, mouseY)) {
            this.method_30901(matrices, Arrays.asList(new class_2588("gauge_text.ad_astra.blocked_warning[0]"), new class_2588("gauge_text.ad_astra.blocked_warning[1]"), new class_2588("gauge_text.ad_astra.blocked_warning[2]")), mouseX, mouseY);
        }
    }

    @Override
    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        super.method_2388(matrices, mouseX, mouseY);
        long oxygenBlocksCount = OxygenUtils.getOxygenBlocksCount(this.blockEntity.method_10997(), this.blockEntity.method_11016());
        matrices.method_22903();
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        class_2588 oxygenBlockText = new class_2588("gauge_text.ad_astra.oxygen_blocks");
        class_2561 oxygenBlockAmount = class_2561.method_30163((String)(oxygenBlocksCount + " / " + AdAstra.CONFIG.oxygenDistributor.maxBlockChecks));
        int offset = 25;
        this.field_22793.method_30883(matrices, (class_2561)oxygenBlockText, 11.0f, (float)(offset + 11), 6871413);
        this.field_22793.method_30883(matrices, oxygenBlockAmount, 11.0f, (float)(offset + 24), 6871413);
        OxygenDistributorBlockEntity entity = (OxygenDistributorBlockEntity)this.blockEntity;
        long energyUsagePerTick = entity.getEnergyToConsume(oxygenBlocksCount, true);
        if (this.displayConversionEnergyCost) {
            energyUsagePerTick += entity.getEnergyPerTick();
            this.displayConversionEnergyCost = false;
        } else if (entity.inputTank.amount > 0L && entity.outputTank.amount < entity.outputTank.getCapacity()) {
            energyUsagePerTick += entity.getEnergyPerTick();
            this.displayConversionEnergyCost = true;
        }
        long oxygenUsagePerTick = entity.getFluidToExtract(oxygenBlocksCount, true);
        float oxygenUsageRounded = FluidUtils.dropletsToMillibucketsFloat(oxygenUsagePerTick);
        oxygenUsageRounded = (float)((double)Math.round((double)oxygenUsageRounded * 1000.0) / 1000.0);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gauge_text.ad_astra.energy_per_tick", new Object[]{energyUsagePerTick}), 11.0f, (float)(offset + -17), 6871413);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gauge_text.ad_astra.fluid_per_tick", new Object[]{Float.valueOf(oxygenUsageRounded)}), 11.0f, (float)(offset + -5), 6871413);
        matrices.method_22909();
    }

    protected void method_25426() {
        super.method_25426();
        OxygenDistributorBlockEntity oxygenDistributor = (OxygenDistributorBlockEntity)this.blockEntity;
        this.visibleButton = new CustomButton(this.field_22789 / 2 + 10, this.field_22790 / 2 - 83, oxygenDistributor.shouldShowOxygen() ? this.HIDE_TEXT : this.SHOW_TEXT, ButtonType.STEEL, ButtonColour.WHITE, PlanetSelectionScreen.TooltipType.NONE, null, pressed -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(this.blockEntity.method_11016());
            ClientPlayNetworking.send((class_2960)ModC2SPackets.TOGGLE_SHOW_DISTRIBUTOR, (class_2540)buf);
            ((OxygenDistributorBlockEntity)this.blockEntity).setShowOxygen(!oxygenDistributor.shouldShowOxygen());
        });
        this.visibleButton.doMask = false;
        this.method_37063((class_364)this.visibleButton);
    }

    public Rectangle getInputTankBounds() {
        return GuiUtil.getFluidTankBounds(this.field_2776 + 50, this.field_2800 + 80);
    }

    public Rectangle getOutputTankBounds() {
        return GuiUtil.getFluidTankBounds(this.field_2776 + 114, this.field_2800 + 80);
    }

    public Rectangle getOxygenLeakWarningSignBounds() {
        return new Rectangle(this.field_22789 / 2 - 85, this.field_22790 / 2 - 137, 14, 15);
    }

    public Rectangle getBlockedWarningSignBounds() {
        return new Rectangle(this.field_22789 / 2 - 67, this.field_22790 / 2 - 137, 14, 15);
    }

    public Rectangle getEnergyBounds() {
        return GuiUtil.getEnergyBounds(this.field_2776 + 147, this.field_2800 + 82);
    }

    @Override
    public int getTextColour() {
        return 2893870;
    }
}

