/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.screens.utils;

import com.github.alexnijjar.ad_astra.client.screens.utils.ButtonType;
import com.github.alexnijjar.ad_astra.client.screens.utils.PlanetSelectionScreen;
import com.github.alexnijjar.ad_astra.data.ButtonColour;
import com.github.alexnijjar.ad_astra.data.Planet;
import com.github.alexnijjar.ad_astra.util.ColourHolder;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class CustomButton
extends class_4185 {
    public static final class_2960 LARGE_BUTTON_TEXTURE = new ModIdentifier("textures/gui/buttons/large_button.png");
    public static final class_2960 BUTTON_TEXTURE = new ModIdentifier("textures/gui/buttons/button.png");
    public static final class_2960 SMALL_BUTTON_TEXTURE = new ModIdentifier("textures/gui/buttons/small_button.png");
    public static final class_2960 STEEL_BUTTON_TEXTURE = new ModIdentifier("textures/gui/buttons/steel_button.png");
    public static final class_2960 WHITE_TEXTURE = new ModIdentifier("textures/white.png");
    private final int startY;
    private final class_2561 label;
    private final ButtonType buttonSize;
    private final ColourHolder buttonColourLightened;
    private final ColourHolder buttonColour;
    private final Planet planetInfo;
    private final PlanetSelectionScreen.TooltipType tooltip;
    public boolean doMask = true;

    public CustomButton(int x, int y, class_2561 label, ButtonType size, ButtonColour buttonColour, PlanetSelectionScreen.TooltipType tooltip, Planet planetInfo, class_4185.class_4241 onPress) {
        super(x, y, size.getWidth(), size.getHeight(), CustomButton.adjustText(label), onPress);
        this.startY = y;
        this.label = label;
        this.buttonSize = size;
        ColourHolder colour = buttonColour.getColour();
        this.buttonColourLightened = new ColourHolder(colour.r() + 0.1f, colour.g() + 0.1f, colour.b() + 0.1f, colour.a());
        this.buttonColour = colour;
        this.tooltip = tooltip;
        this.planetInfo = planetInfo;
    }

    public static class_2561 adjustText(class_2561 label) {
        int length = label.getString().length();
        if (length > 12 && length != 13) {
            return class_2561.method_30163((String)(label.method_10858(12) + "."));
        }
        return label;
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.field_22761 = this.startY;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            class_310 client = class_310.method_1551();
            double scale = client.method_22683().method_4495();
            int screenHeight = client.method_22683().method_4502();
            int scissorY = (int)((double)(screenHeight / 2 - 83) * scale);
            ColourHolder lightColour = this.buttonColourLightened;
            ColourHolder color = this.buttonColour;
            boolean over = this.method_25405(mouseX, mouseY);
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.enableDepthTest();
            if (this.doMask) {
                RenderSystem.enableScissor((int)0, (int)scissorY, (int)((int)(215.0 * scale)), (int)((int)(127.0 * scale)));
            }
            RenderSystem.setShaderColor((float)(over ? lightColour.r() : color.r()), (float)(over ? lightColour.g() : color.g()), (float)(over ? lightColour.b() : color.b()), (float)color.a());
            RenderSystem.setShaderTexture((int)0, (class_2960)(switch (this.buttonSize) {
                default -> throw new IncompatibleClassChangeError();
                case ButtonType.LARGE -> LARGE_BUTTON_TEXTURE;
                case ButtonType.NORMAL -> BUTTON_TEXTURE;
                case ButtonType.SMALL -> SMALL_BUTTON_TEXTURE;
                case ButtonType.STEEL -> STEEL_BUTTON_TEXTURE;
            }));
            CustomButton.method_25290((class_4587)matrices, (int)(this.buttonSize.equals((Object)ButtonType.LARGE) ? this.field_22760 - 2 : this.field_22760), (int)this.field_22761, (float)0.0f, (float)0.0f, (int)this.field_22758, (int)this.field_22759, (int)this.buttonSize.getWidth(), (int)this.buttonSize.getHeight());
            this.drawText(matrices, client);
            if (this.doMask) {
                RenderSystem.disableScissor();
            }
            if (this.method_25405(mouseX, mouseY)) {
                this.renderTooltips(matrices, mouseX, mouseY, client);
            }
            RenderSystem.disableDepthTest();
        }
    }

    public void drawText(class_4587 matrices, class_310 client) {
        class_327 textRenderer = client.field_1772;
        int colour = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        matrices.method_22903();
        float scale = 0.9f;
        matrices.method_22905(scale, scale, scale);
        int x = this.buttonSize.equals((Object)ButtonType.LARGE) ? this.field_22760 - 2 : this.field_22760;
        matrices.method_22904((double)(4.0f + (float)x / 9.5f), (double)((float)this.field_22761 / 8.5f), 0.0);
        CustomButton.method_27534((class_4587)matrices, (class_327)textRenderer, (class_2561)this.method_25369(), (int)(x + this.field_22758 / 2), (int)(this.field_22761 + (this.field_22759 - 8) / 2), (int)(colour | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
        matrices.method_22909();
    }

    public int getStartY() {
        return this.startY;
    }

    private void renderTooltips(class_4587 matrices, int mouseX, int mouseY, class_310 client) {
        class_437 screen = client.field_1755;
        LinkedList<class_2561> textEntries = new LinkedList<class_2561>();
        switch (this.tooltip) {
            case NONE: {
                break;
            }
            case GALAXY: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a75" + PlanetSelectionScreen.GALAXY_TEXT.getString())));
                break;
            }
            case SOLAR_SYSTEM: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.SOLAR_SYSTEM_TEXT.getString())));
                break;
            }
            case CATEGORY: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7a" + this.label.getString())));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.PROVIDED_TEXT.getString() + ": \u00a7bTier " + this.planetInfo.rocketTier() + " Rocket")));
                break;
            }
            case PLANET: {
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + (this.planetInfo.parentWorld() == null ? PlanetSelectionScreen.PLANET_TEXT.getString() : PlanetSelectionScreen.MOON_TEXT.getString()))));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + this.planetInfo.gravity() + " m/s")));
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7" + (this.planetInfo.hasOxygen() ? "a" + PlanetSelectionScreen.OXYGEN_TRUE_TEXT.getString() : "c" + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString()))));
                String temperatureColour = "\u00a7a";
                if (this.planetInfo.temperature() > 50.0f) {
                    temperatureColour = "\u00a76";
                } else if (this.planetInfo.temperature() < -20.0f) {
                    temperatureColour = "\u00a71";
                }
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": " + temperatureColour + " " + this.planetInfo.temperature() + " \u00b0C")));
                break;
            }
            case SPACE_STATION: {
                PlanetSelectionScreen currentScreen = (PlanetSelectionScreen)client.field_1755;
                textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.ITEM_REQUIREMENT_TEXT.getString())));
                currentScreen.ingredients.forEach(ingredient -> {
                    boolean isEnough = ((class_1799)ingredient.first).method_7947() >= (Integer)ingredient.second;
                    textEntries.add(class_2561.method_30163((String)("\u00a7" + (isEnough ? "a" : "c") + ((class_1799)ingredient.first).method_7947() + "/" + ingredient.second + " \u00a73" + ((class_1799)ingredient.first).method_7964().getString())));
                });
                textEntries.add(class_2561.method_30163((String)"\u00a7c----------------"));
                break;
            }
        }
        if (this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.ORBIT) || this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.SPACE_STATION)) {
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.ORBIT_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.NO_GRAVITY_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7c " + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString())));
            textEntries.add(class_2561.method_30163((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a71 -270.0 \u00b0C")));
        }
        screen.method_30901(matrices, textEntries, mouseX, mouseY);
    }
}

