/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.entities.vehicles;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.items.vehicles.VehicleItem;
import com.github.alexnijjar.ad_astra.registry.ModTags;
import com.github.alexnijjar.ad_astra.screen.VehicleScreenHandlerFactory;
import com.github.alexnijjar.ad_astra.util.CustomInventory;
import com.github.alexnijjar.ad_astra.util.FluidUtils;
import com.github.alexnijjar.ad_astra.util.entity.OxygenUtils;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleEntity
extends class_1297 {
    protected double clientX;
    protected double clientY;
    protected double clientZ;
    public double clientYaw;
    public double clientPitch;
    private int clientInterpolationSteps;
    protected double clientXVelocity;
    protected double clientYVelocity;
    protected double clientZVelocity;
    public float previousYaw;
    public final SingleVariantStorage<FluidVariant> inputTank = FluidUtils.createTank(this.getTankSize());
    private final CustomInventory inventory = new CustomInventory(this.getInventorySize());
    protected static final class_2940<Float> SPEED = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> FLUID_AMOUNT = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<String> FLUID_VARIANT = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13326);

    public VehicleEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693() {
        this.field_6011.method_12784(SPEED, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(FLUID_AMOUNT, (Object)0);
        this.field_6011.method_12784(FLUID_VARIANT, (Object)"ad_astra:fuel");
    }

    protected void method_5749(class_2487 nbt) {
        this.inventory.method_7659(nbt.method_10554("inventory", 10));
        this.inputTank.variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("inputFluid"));
        this.inputTank.amount = nbt.method_10537("inputAmount");
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
        nbt.method_10566("inputFluid", (class_2520)((FluidVariant)this.inputTank.variant).toNbt());
        nbt.method_10544("inputAmount", this.inputTank.amount);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.clientInterpolationSteps = 10;
        this.method_18800(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    private void updatePositionAndRotation() {
        if (this.method_5787()) {
            this.clientInterpolationSteps = 0;
            this.method_18003(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.clientInterpolationSteps <= 0) {
            return;
        }
        double d = this.method_23317() + (this.clientX - this.method_23317()) / (double)this.clientInterpolationSteps;
        double e = this.method_23318() + (this.clientY - this.method_23318()) / (double)this.clientInterpolationSteps;
        double f = this.method_23321() + (this.clientZ - this.method_23321()) / (double)this.clientInterpolationSteps;
        double g = class_3532.method_15338((double)(this.clientYaw - (double)this.method_36454()));
        this.method_36456(this.method_36454() + (float)g / (float)this.clientInterpolationSteps);
        this.method_36457(this.method_36455() + (float)(this.clientPitch - (double)this.method_36455()) / (float)this.clientInterpolationSteps);
        --this.clientInterpolationSteps;
        this.method_5814(d, e, f);
        this.method_5710(this.method_36454(), this.method_36455());
    }

    public void method_5750(double x, double y, double z) {
        this.clientXVelocity = x;
        this.clientYVelocity = y;
        this.clientZVelocity = z;
        this.method_18800(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    public void method_5773() {
        this.previousYaw = this.method_36454();
        super.method_5773();
        this.updatePositionAndRotation();
        this.doMovement();
        this.slowDown();
        this.doGravity();
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_5852();
        this.tryInsertingIntoTank();
        if (!this.field_6002.field_9236) {
            this.field_6011.method_12778(FLUID_AMOUNT, (Object)((int)this.inputTank.amount));
            this.field_6011.method_12778(FLUID_VARIANT, (Object)class_2378.field_11154.method_10221((Object)((FluidVariant)this.inputTank.variant).getFluid()).toString());
        }
    }

    public void doMovement() {
        this.method_36457(0.0f);
        class_243 movement = this.method_5631(this.method_36455(), this.method_36454());
        double yVelocity = this.method_18798().method_10214();
        this.method_18799(this.method_18798().method_1031(movement.method_10216(), 0.0, movement.method_10215()).method_1021((double)this.getSpeed()));
        this.method_18799(new class_243(this.method_18798().method_10216(), yVelocity, this.method_18798().method_10215()));
    }

    public void slowDown() {
        this.setSpeed(this.getSpeed() / 1.05f);
        if ((double)this.getSpeed() < 0.001 && (double)this.getSpeed() > -0.001) {
            this.setSpeed(0.0f);
        }
        this.setSpeed(class_3532.method_15363((float)this.getSpeed(), (float)this.getMinSpeed(), (float)this.getMaxSpeed()));
    }

    public float getMinSpeed() {
        return -0.2f;
    }

    public float getMaxSpeed() {
        return 0.4f;
    }

    public void doGravity() {
        if (!this.field_6002.method_22340(this.method_24515())) {
            return;
        }
        if (!this.method_5740()) {
            if (this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, -1.0E-4, 0.0));
            } else {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            if (this.method_18798().method_10214() < AdAstra.CONFIG.vehicles.gravity) {
                this.method_18799(new class_243(this.method_18798().method_10216(), AdAstra.CONFIG.vehicles.gravity, this.method_18798().method_10215()));
            }
        }
    }

    public float getSpeed() {
        return ((Float)this.field_6011.method_12789(SPEED)).floatValue();
    }

    public void setSpeed(float value) {
        this.field_6011.method_12778(SPEED, (Object)Float.valueOf(value));
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.field_6002.field_9236) {
            if (this.method_5685().size() > this.getMaxPassengers()) {
                return class_1269.field_5811;
            }
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public void openInventory(class_1657 player) {
        this.openInventory(player, new VehicleScreenHandlerFactory(this));
    }

    public void openInventory(class_1657 player, ExtendedScreenHandlerFactory handler) {
        if (!player.field_6002.field_9236 && player.method_5715()) {
            player.method_17355((class_3908)handler);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        if (amount > 0.0f && (class_12972 = source.method_5529()) instanceof class_1657 && !((player = (class_1657)class_12972).method_5854() instanceof VehicleEntity)) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        if (this.getDropStack() != null && this.field_6002.method_8450().method_8355(class_1928.field_19392)) {
            class_2338 pos = this.method_24515();
            class_1799 dropStack = this.getDropStack();
            ((VehicleItem)dropStack.method_7909()).setAmount(dropStack, this.inputTank.amount);
            ((VehicleItem)dropStack.method_7909()).setFluid(dropStack, (FluidVariant)this.inputTank.variant);
            class_2487 nbt = dropStack.method_7948();
            nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
            this.field_6002.method_8396(null, pos, class_3417.field_21919, class_3419.field_15245, 1.0f, 1.0f);
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, (double)pos.method_10263(), (double)((float)pos.method_10264() + 0.5f), (double)pos.method_10260(), dropStack));
        }
        if (!this.field_6002.field_9236) {
            this.method_31472();
        }
    }

    public void explode(float powerMultiplier) {
        if (!this.field_6002.field_9236) {
            this.field_6002.method_8537((class_1297)this, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 7.0f * powerMultiplier, OxygenUtils.worldHasOxygen(this.field_6002), class_1927.class_4179.field_18687);
        }
        this.method_31472();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (this.method_18798().method_10214() < AdAstra.CONFIG.vehicles.fallingExplosionThreshold && this.method_24828()) {
            this.explode(AdAstra.CONFIG.vehicles.fallingExplosionMultiplier);
            return true;
        }
        return false;
    }

    public class_1799 getDropStack() {
        return null;
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return 1;
    }

    public double method_5621() {
        return 0.0;
    }

    public boolean shouldSit() {
        return true;
    }

    public boolean shouldRenderPlayer() {
        return true;
    }

    public boolean doHighFov() {
        return false;
    }

    public boolean fullyConcealsRider() {
        return false;
    }

    public boolean canRiderTakeFallDamage() {
        return true;
    }

    public boolean renderPlanetBar() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return true;
    }

    public long getTankSize() {
        return 0L;
    }

    public long getFuelPerTick() {
        return 0L;
    }

    public CustomInventory getInventory() {
        return this.inventory;
    }

    public abstract int getInventorySize();

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void tryInsertingIntoTank() {
        if (this.getInventorySize() > 1 && !this.field_6002.field_9236) {
            FluidUtils.insertFluidIntoTank((class_1263)this.getInventory(), this.inputTank, 0, 1, f -> f.getFluid().method_15791(ModTags.FUELS));
        }
    }

    public int getFluidAmount() {
        return (Integer)this.field_6011.method_12789(FLUID_AMOUNT);
    }

    public FluidVariant getFluidVariant() {
        return FluidVariant.of((class_3611)((class_3611)class_2378.field_11154.method_10223(new class_2960((String)this.field_6011.method_12789(FLUID_VARIANT)))));
    }

    public void consumeFuel() {
        if (!this.field_6002.field_9236) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.inputTank.extract((TransferVariant)((FluidVariant)this.inputTank.getResource()), this.getFuelPerTick(), (TransactionContext)transaction) > 0L) {
                    transaction.commit();
                }
            }
        }
    }
}

