/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.items;

import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;

public interface FluidContainingItem {
    public long getTankSize();

    default public boolean insertIntoTank(Storage<FluidVariant> storage, class_1799 stack) {
        try (Transaction transaction = Transaction.openOuter();){
            if (storage.insert((Object)this.getFluid(stack), this.getAmount(stack), (TransactionContext)transaction) == this.getAmount(stack)) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public List<class_3611> getInputFluids();

    default public long transferFluid(Storage<FluidVariant> from, Storage<FluidVariant> to) {
        return StorageUtil.move(from, to, f -> true, (long)Long.MAX_VALUE, null);
    }

    default public FluidVariant getFluid(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("fluid")) {
            return FluidVariant.fromNbt((class_2487)nbt.method_10562("fluid"));
        }
        return FluidVariant.blank();
    }

    default public void setFluid(class_1799 stack, FluidVariant variant) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10566("fluid", (class_2520)variant.toNbt());
    }

    default public long getAmount(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("amount")) {
            return nbt.method_10537("amount");
        }
        return 0L;
    }

    default public void setAmount(class_1799 stack, long amount) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10544("amount", amount);
    }

    public static class TankStorage
    extends SingleVariantItemStorage<FluidVariant> {
        private final FluidContainingItem item;

        public TankStorage(class_1799 stack, ContainerItemContext context) {
            super(context);
            this.item = (FluidContainingItem)stack.method_7909();
        }

        protected boolean canInsert(FluidVariant resource) {
            return this.item.getInputFluids().contains(resource.getFluid());
        }

        protected FluidVariant getBlankResource() {
            return FluidVariant.blank();
        }

        protected FluidVariant getResource(ItemVariant currentVariant) {
            return this.item.getFluid(currentVariant.toStack());
        }

        protected long getAmount(ItemVariant currentVariant) {
            return this.item.getAmount(currentVariant.toStack());
        }

        protected long getCapacity(FluidVariant variant) {
            return this.item.getTankSize();
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
            class_1799 stack = new class_1799((class_1935)currentVariant.getItem());
            class_2487 nbt = currentVariant.copyNbt();
            if (nbt != null && !nbt.method_33133()) {
                if (nbt.method_10545("fluid")) {
                    nbt.method_10551("fluid");
                }
                if (nbt.method_10545("amount")) {
                    nbt.method_10551("amount");
                }
                stack.method_7980(nbt);
            }
            if (!newResource.isBlank() && newAmount > 0L) {
                this.item.setFluid(stack, newResource);
                this.item.setAmount(stack, newAmount);
            }
            return ItemVariant.of((class_1799)stack);
        }
    }
}

