/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.items.vehicles;

import com.github.alexnijjar.ad_astra.blocks.door.LocationState;
import com.github.alexnijjar.ad_astra.blocks.launchpad.LaunchPad;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntity;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntityTier1;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntityTier2;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntityTier3;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntityTier4;
import com.github.alexnijjar.ad_astra.items.vehicles.VehicleItem;
import com.github.alexnijjar.ad_astra.registry.ModTags;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;

public class RocketItem<T extends RocketEntity>
extends VehicleItem {
    private final class_1299<T> rocketEntity;
    private final int tier;

    public RocketItem(class_1299<T> rocketEntity, int tier, class_1792.class_1793 settings) {
        super(settings);
        this.rocketEntity = rocketEntity;
        this.tier = tier;
    }

    @Override
    public List<class_3611> getInputFluids() {
        return class_2378.field_11154.method_29722().stream().filter(e -> ((class_3611)e.getValue()).method_15791(ModTags.FUELS)).map(f -> (class_3611)f.getValue()).toList();
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (!world.field_9236) {
            class_1792 testBlockPos;
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            class_1657 player = context.method_8036();
            for (int x = pos.method_10263() - 1; x < pos.method_10263() + 2; ++x) {
                for (int y = pos.method_10264() + 1; y < pos.method_10264() + 9; ++y) {
                    for (int z = pos.method_10260() - 1; z < pos.method_10260() + 2; ++z) {
                        testBlockPos = new class_2338(x, y, z);
                        class_2680 testBlock = world.method_8320((class_2338)testBlockPos);
                        if (testBlock.method_26215() || testBlock.method_26204() instanceof class_2404) continue;
                        return class_1269.field_5814;
                    }
                }
            }
            class_2248 y = state.method_26204();
            if (y instanceof LaunchPad) {
                class_1799 rocketStack;
                LaunchPad pad = (LaunchPad)y;
                if (((LocationState)((Object)state.method_11654(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER) && (testBlockPos = (rocketStack = player.method_5998(context.method_20287())).method_7909()) instanceof RocketItem) {
                    RocketItem rocket = (RocketItem)testBlockPos;
                    RocketEntity rocketEntity = null;
                    int tier = rocket.getTier();
                    switch (tier) {
                        case 1: {
                            rocketEntity = new RocketEntityTier1(rocket.getRocketEntity(), world);
                            break;
                        }
                        case 2: {
                            rocketEntity = new RocketEntityTier2(rocket.getRocketEntity(), world);
                            break;
                        }
                        case 3: {
                            rocketEntity = new RocketEntityTier3(rocket.getRocketEntity(), world);
                            break;
                        }
                        case 4: {
                            rocketEntity = new RocketEntityTier4(rocket.getRocketEntity(), world);
                        }
                    }
                    if (rocketEntity != null) {
                        class_238 scanAbove = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1));
                        List entities = world.method_8390(RocketEntity.class, scanAbove, entity -> true);
                        if (!entities.isEmpty()) {
                            return class_1269.field_5811;
                        }
                        class_2487 nbt = rocketStack.method_7948();
                        if (nbt.method_10545("fluid") && !this.getFluid(rocketStack).isBlank()) {
                            this.insertIntoTank((Storage)rocketEntity.inputTank, rocketStack);
                        }
                        if (nbt.method_10545("inventory")) {
                            rocketEntity.getInventory().method_7659(nbt.method_10554("inventory", 10));
                        }
                        rocketEntity.assignLaunchPad(true);
                        rocketStack.method_7934(1);
                        world.method_8396(null, pos, class_3417.field_21921, class_3419.field_15245, 1.0f, 1.0f);
                        rocketEntity.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5);
                        rocketEntity.method_36456(Math.round((player.method_36454() + 180.0f) / 90.0f) * 90);
                        world.method_8649((class_1297)rocketEntity);
                        return class_1269.field_5812;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    public class_1299<T> getRocketEntity() {
        return this.rocketEntity;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public long getTankSize() {
        return 243000L;
    }
}

