/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.networking;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.flags.FlagBlockEntity;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.OxygenDistributorBlockEntity;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntity;
import com.github.alexnijjar.ad_astra.networking.ModS2CPackets;
import com.github.alexnijjar.ad_astra.networking.packets.CreateSpaceStationPacket;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.github.alexnijjar.ad_astra.util.ModKeyBindings;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class ModC2SPackets {
    public static final class_2960 TELEPORT_TO_PLANET = new ModIdentifier("teleport_to_planet");
    public static final class_2960 CREATE_SPACE_STATION = new ModIdentifier("create_space_station");
    public static final class_2960 LAUNCH_ROCKET = new ModIdentifier("launch_rocket");
    public static final class_2960 KEY_CHANGED = new ModIdentifier("key_changed");
    public static final class_2960 TOGGLE_SHOW_DISTRIBUTOR = new ModIdentifier("toggle_show_distributor");
    public static final class_2960 FLAG_URL = new ModIdentifier("flag_url");

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                sender.sendPacket(ModS2CPackets.DATAPACK_PLANETS, ModC2SPackets.createPlanetsDatapackBuf());
            }
            catch (Exception e) {
                AdAstra.LOGGER.error("Failed to send datapack values to client: " + e);
                e.printStackTrace();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TELEPORT_TO_PLANET, (server, player, handler, buf, responseSender) -> {
            class_5321<class_1937> targetDimension = ModC2SPackets.getWorld(buf.method_10810());
            server.execute(() -> {
                if (player.method_5854() instanceof RocketEntity) {
                    ModUtils.teleportToWorld(targetDimension, (class_1297)player);
                } else {
                    ModUtils.teleportPlayer(targetDimension, player);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CREATE_SPACE_STATION, (ServerPlayNetworking.PlayChannelHandler)new CreateSpaceStationPacket());
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LAUNCH_ROCKET, (server, player, handler, buf, responseSender) -> {
            RocketEntity rocket;
            class_1297 patt2947$temp = player.method_5854();
            if (patt2947$temp instanceof RocketEntity && !(rocket = (RocketEntity)patt2947$temp).isFlying()) {
                rocket.initiateLaunchSequenceFromServer();
                int id = buf.readInt();
                for (class_3222 serverPlayer : server.method_3760().method_14571()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.writeInt(id);
                    serverPlayer.field_13987.method_14364(responseSender.createPacket(ModS2CPackets.START_ROCKET, buffer));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)KEY_CHANGED, (server, player, handler, buf, responseSender) -> ModKeyBindings.pressedKeyOnServer(player.method_5667(), (ModKeyBindings.Key)buf.method_10818(ModKeyBindings.Key.class), buf.readBoolean()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TOGGLE_SHOW_DISTRIBUTOR, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            class_2586 patt3895$temp = player.field_6002.method_8321(buf.method_10811());
            if (patt3895$temp instanceof OxygenDistributorBlockEntity) {
                OxygenDistributorBlockEntity oxygenDistributor;
                oxygenDistributor.setShowOxygen(!(oxygenDistributor = (OxygenDistributorBlockEntity)patt3895$temp).shouldShowOxygen());
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FLAG_URL, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            String url = buf.method_19772();
            if (AdAstra.CONFIG.general.allowFlagImages || player.method_7338()) {
                server.execute(() -> {
                    FlagBlockEntity flag;
                    class_2586 patt4379$temp = player.field_6002.method_8321(pos);
                    if (patt4379$temp instanceof FlagBlockEntity && (flag = (FlagBlockEntity)patt4379$temp).getOwner() != null && player.method_5667().equals(flag.getOwner().getId())) {
                        flag.setId(url);
                        class_2680 blockState = player.field_6002.method_8320(pos);
                        player.field_6002.method_8413(pos, blockState, blockState, 3);
                    }
                });
            }
        });
    }

    private static class_5321<class_1937> getWorld(class_2960 id) {
        class_5321 targetDimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)id);
        if (targetDimension.method_29177().equals((Object)new ModIdentifier("earth"))) {
            targetDimension = class_1937.field_25179;
        }
        return targetDimension;
    }

    private static class_2540 createPlanetsDatapackBuf() {
        class_2540 mainBuf = PacketByteBufs.create();
        mainBuf.method_34062(AdAstra.planets, (buf, planet) -> {
            buf.method_10814(planet.translation());
            buf.method_10812(planet.galaxy());
            buf.method_10812(planet.solarSystem());
            buf.method_10812(planet.world().method_29177());
            buf.method_10812(planet.orbitWorld().method_29177());
            buf.method_10812(planet.parentWorld() == null ? new class_2960("empty") : planet.parentWorld().method_29177());
            buf.writeInt(planet.rocketTier());
            buf.writeFloat(planet.gravity());
            buf.writeBoolean(planet.hasAtmosphere());
            buf.writeInt(planet.daysInYear());
            buf.writeFloat(planet.temperature());
            buf.writeLong(planet.solarPower());
            buf.writeLong(planet.orbitSolarPower());
            buf.writeBoolean(planet.hasOxygen());
            buf.method_10817((Enum)planet.buttonColour());
        });
        return mainBuf;
    }
}

