/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.networking;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.data.ButtonColour;
import com.github.alexnijjar.ad_astra.data.Planet;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntity;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ModS2CPackets {
    public static final class_2960 DATAPACK_PLANETS = new ModIdentifier("datapack_planets");
    public static final class_2960 START_ROCKET = new ModIdentifier("start_rocket");

    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DATAPACK_PLANETS, (client, handler, mainBuf, responseSender) -> {
            AdAstra.planets = new HashSet<Planet>(mainBuf.method_34066(buf -> {
                String translation = buf.method_19772();
                class_2960 galaxy = buf.method_10810();
                class_2960 solarSystem = buf.method_10810();
                class_5321 dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
                class_5321 orbitDimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
                class_2960 id = buf.method_10810();
                class_5321 parentWorld = id.equals((Object)new class_2960("empty")) ? null : class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)id);
                int rocketTier = buf.readInt();
                float gravity = buf.readFloat();
                boolean hasAtmosphere = buf.readBoolean();
                int daysInYear = buf.readInt();
                float temperature = buf.readFloat();
                long solarPower = buf.readLong();
                long orbitSolarPower = buf.readLong();
                boolean hasOxygen = buf.readBoolean();
                ButtonColour buttonColour = (ButtonColour)buf.method_10818(ButtonColour.class);
                return new Planet(translation, galaxy, solarSystem, (class_5321<class_1937>)dimension, (class_5321<class_1937>)orbitDimension, (class_5321<class_1937>)parentWorld, rocketTier, gravity, hasAtmosphere, daysInYear, temperature, solarPower, orbitSolarPower, hasOxygen, buttonColour);
            }));
            AdAstra.planetWorlds = AdAstra.planets.stream().map(Planet::world).collect(Collectors.toSet());
            AdAstra.orbitWorlds = AdAstra.planets.stream().map(Planet::orbitWorld).collect(Collectors.toSet());
            AdAstra.adAstraWorlds = Stream.concat(AdAstra.planetWorlds.stream(), AdAstra.orbitWorlds.stream()).collect(Collectors.toSet());
            AdAstra.worldsWithOxygen = AdAstra.planets.stream().filter(Planet::hasOxygen).map(Planet::world).collect(Collectors.toSet());
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)START_ROCKET, (client, handler, buf, responseSender) -> {
            RocketEntity rocket;
            int id = buf.readInt();
            class_1297 patt3046$temp = client.field_1687.method_8469(id);
            if (patt3046$temp instanceof RocketEntity && !(rocket = (RocketEntity)patt3046$temp).isFlying()) {
                rocket.initiateLaunchSequence();
            }
        });
    }
}

