/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.util.entity;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.registry.ModBlocks;
import com.github.alexnijjar.ad_astra.registry.ModFluids;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2372;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3922;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import org.apache.commons.lang3.tuple.Pair;

public class OxygenUtils {
    public static final Map<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>> OXYGEN_LOCATIONS = new HashMap<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>>();

    public static boolean worldHasOxygen(class_1937 world) {
        if (!AdAstra.worldsWithOxygen.contains(world.method_27983())) {
            return !ModUtils.isSpaceWorld(world);
        }
        return true;
    }

    public static boolean entityHasOxygen(class_1937 world, class_1309 entity) {
        return OxygenUtils.posHasOxygen(world, new class_2338(entity.method_33571()));
    }

    public static boolean posHasOxygen(class_1937 world, class_2338 pos) {
        if (!world.method_22340(pos)) {
            return true;
        }
        if (OxygenUtils.worldHasOxygen(world)) {
            return true;
        }
        return OxygenUtils.inDistributorBubble(world, pos);
    }

    public static boolean inDistributorBubble(class_1937 world, class_2338 pos) {
        for (Map.Entry<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>> entry : OXYGEN_LOCATIONS.entrySet()) {
            if (!world.method_27983().equals(entry.getKey().getLeft()) || !entry.getValue().contains(pos)) continue;
            return true;
        }
        return false;
    }

    public static int getOxygenBlocksCount(class_1937 world, class_2338 source) {
        return OXYGEN_LOCATIONS.getOrDefault(OxygenUtils.getOxygenSource(world, source), Set.of()).size();
    }

    public static void setEntry(class_1937 world, class_2338 source, Set<class_2338> entries) {
        HashSet<class_2338> changedPositions;
        if (!world.field_9236 && OXYGEN_LOCATIONS.containsKey(OxygenUtils.getOxygenSource(world, source)) && (changedPositions = new HashSet<class_2338>((Collection)OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource(world, source)))) != null && !changedPositions.isEmpty()) {
            changedPositions.removeAll(entries);
            OxygenUtils.deoxygenizeBlocks((class_3218)world, changedPositions, source);
        }
        OXYGEN_LOCATIONS.put(OxygenUtils.getOxygenSource(world, source), entries);
    }

    public static void removeEntry(class_1937 world, class_2338 source) {
        OxygenUtils.setEntry(world, source, Set.of());
    }

    public static void deoxygenizeBlocks(class_3218 world, Set<class_2338> entries, class_2338 source) {
        try {
            if (entries == null) {
                return;
            }
            if (entries.isEmpty()) {
                return;
            }
            if (OxygenUtils.worldHasOxygen((class_1937)world)) {
                OXYGEN_LOCATIONS.remove(OxygenUtils.getOxygenSource((class_1937)world, source));
                return;
            }
            for (class_2338 pos : new HashSet<class_2338>(entries)) {
                class_2680 state = world.method_8320(pos);
                OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource((class_1937)world, source)).remove(pos);
                if (OxygenUtils.posHasOxygen((class_1937)world, pos) || state.method_26215()) continue;
                class_2248 block = state.method_26204();
                if (block instanceof class_2555 && !block.equals(class_2246.field_22093)) {
                    world.method_8501(pos, (class_2680)ModBlocks.WALL_COAL_TORCH.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)((class_2350)state.method_11654((class_2769)class_2555.field_11731))));
                    continue;
                }
                if (block instanceof class_2527 && !block.equals(class_2246.field_22092) && !block.equals(class_2246.field_22093)) {
                    world.method_8501(pos, ModBlocks.COAL_TORCH.method_9564());
                    continue;
                }
                if (block instanceof class_5545) {
                    world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_5545.field_27183, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof class_5544) {
                    world.method_8501(pos, (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_5544.field_27174, (Comparable)((Integer)state.method_11654((class_2769)class_5544.field_27174)))).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof class_2358) {
                    world.method_8650(pos, false);
                    continue;
                }
                if (block instanceof class_3922) {
                    world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_3922.field_17564, (Comparable)((class_2350)state.method_11654((class_2769)class_3922.field_17564))));
                    continue;
                }
                if (block instanceof class_2372) {
                    world.method_8501(pos, class_2246.field_10566.method_9564());
                    continue;
                }
                if (block instanceof class_2261 || block instanceof class_2266 || block instanceof class_2541) {
                    world.method_8650(pos, true);
                    continue;
                }
                if (block instanceof class_2344) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(0)));
                    continue;
                }
                if (!state.method_26227().method_15767(class_3486.field_15517)) continue;
                if (!block.equals(ModFluids.CRYO_FUEL_BLOCK)) {
                    if (ModUtils.getWorldTemperature((class_1937)world) < 0.0f) {
                        world.method_8501(pos, class_2246.field_10295.method_9564());
                        continue;
                    }
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                    continue;
                }
                if (!state.method_28498((class_2769)class_2741.field_12508)) continue;
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
            }
        }
        catch (UnsupportedOperationException e) {
            AdAstra.LOGGER.error("Error deoxygenizing blocks");
            e.printStackTrace();
        }
    }

    private static Pair<class_5321<class_1937>, class_2338> getOxygenSource(class_1937 world, class_2338 source) {
        return Pair.of((Object)world.method_27983(), (Object)source);
    }
}

