/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFCacheKey;
import traben.entity_texture_features.utils.ETFLruCache;
import traben.entity_texture_features.utils.ETFTexturePropertiesUtils;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFManager {
    public static final UUID ETF_GENERIC_UUID = UUID.nameUUIDFromBytes("GENERIC".getBytes());
    private static final ETFTexture ETF_ERROR_TEXTURE = ETFManager.getErrorETFTexture();
    public boolean zombiePiglinRightEarEnabled = false;
    private static ETFManager manager;
    public final ObjectOpenHashSet<String> EMISSIVE_SUFFIX_LIST = new ObjectOpenHashSet();
    public final Object2ReferenceOpenHashMap<UUID, String> UUID_TRIDENT_NAME = new Object2ReferenceOpenHashMap();
    public final ETFLruCache<ETFCacheKey, ETFTexture> ENTITY_TEXTURE_MAP = new ETFLruCache();
    public final ETFLruCache<UUID, ETFPlayerTexture> PLAYER_TEXTURE_MAP = new ETFLruCache();
    public final Object2LongOpenHashMap<UUID> ENTITY_BLINK_TIME = new Object2LongOpenHashMap();
    public final Object2ObjectOpenHashMap<UUID, ETFCacheKey> UUID_TO_MOB_CACHE_KEY_MAP_FOR_FEATURE_USAGE = new Object2ObjectOpenHashMap();
    public final Object2BooleanOpenHashMap<class_2960> DOES_IDENTIFIER_EXIST_CACHED_RESULT = new Object2BooleanOpenHashMap();
    public final ArrayList<String> KNOWN_RESOURCEPACK_ORDER = new ArrayList();
    public final Object2IntOpenHashMap<class_1299<?>> ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE = new Object2IntOpenHashMap();
    public final ObjectOpenHashSet<class_1299<?>> ENTITY_TYPE_IGNORE_PARTICLES = new ObjectOpenHashSet();
    public final Object2IntOpenHashMap<class_1299<?>> ENTITY_TYPE_RENDER_LAYER = new Object2IntOpenHashMap();
    public final Object2ObjectOpenHashMap<class_2960, ETFTexture> TEXTURE_MAP_TO_OPPOSITE_ELYTRA = new Object2ObjectOpenHashMap();
    public final ETFLruCache<UUID, ObjectImmutableList<String>> ENTITY_SPAWN_CONDITIONS_CACHE = new ETFLruCache();
    private final Object2ReferenceOpenHashMap<@NotNull class_2960, @Nullable ETFTexture> ETF_TEXTURE_CACHE = new Object2ReferenceOpenHashMap();
    public final Object2ReferenceOpenHashMap<class_2960, @Nullable List<ETFTexturePropertiesUtils.ETFTexturePropertyCase>> OPTIFINE_PROPERTY_CACHE = new Object2ReferenceOpenHashMap();
    private final Object2BooleanOpenHashMap<UUID> ENTITY_IS_UPDATABLE = new Object2BooleanOpenHashMap();
    private final ObjectOpenHashSet<UUID> ENTITY_UPDATE_QUEUE = new ObjectOpenHashSet();
    private final Object2ObjectOpenHashMap<UUID, ObjectOpenHashSet<ETFCacheKey>> ENTITY_KNOWN_FEATURES_LIST = new Object2ObjectOpenHashMap();
    private final ObjectOpenHashSet<UUID> ENTITY_DEBUG_QUEUE = new ObjectOpenHashSet();
    private final Object2IntOpenHashMap<class_2960> TRUE_RANDOM_COUNT_CACHE = new Object2IntOpenHashMap();
    public int mooshroomBrownCustomShroom = 0;
    public int mooshroomRedCustomShroom = 0;
    public Boolean lecternHasCustomTexture = null;
    public ETFTexture redMooshroomAlt = null;
    public ETFTexture brownMooshroomAlt = null;

    private ETFManager() {
        for (class_3262 pack : class_310.method_1551().method_1478().method_29213().toList()) {
            this.KNOWN_RESOURCEPACK_ORDER.add(pack.method_14409());
        }
        try {
            ArrayList<Properties> props = new ArrayList<Properties>();
            String[] paths = new String[]{"optifine/emissive.properties", "textures/emissive.properties", "etf/emissive.properties"};
            for (String path : paths) {
                Properties prop = ETFUtils2.readAndReturnPropertiesElseNull(new class_2960(path));
                if (prop == null) continue;
                props.add(prop);
            }
            for (Properties prop : props) {
                if (prop.containsKey("entities.suffix.emissive") && prop.getProperty("entities.suffix.emissive") != null) {
                    this.EMISSIVE_SUFFIX_LIST.add((Object)prop.getProperty("entities.suffix.emissive"));
                }
                if (!prop.containsKey("suffix.emissive") || prop.getProperty("suffix.emissive") == null) continue;
                this.EMISSIVE_SUFFIX_LIST.add((Object)prop.getProperty("suffix.emissive"));
            }
            if (ETFClientCommon.ETFConfigData.alwaysCheckVanillaEmissiveSuffix) {
                this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
            }
            if (this.EMISSIVE_SUFFIX_LIST.isEmpty()) {
                ETFUtils2.logMessage("no emissive suffixes found: default emissive suffix '_e' used");
                this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
            } else {
                ETFUtils2.logMessage("emissive suffixes loaded: " + this.EMISSIVE_SUFFIX_LIST);
            }
        }
        catch (Exception e) {
            ETFUtils2.logError("emissive suffixes could not be read: default emissive suffix '_e' used");
            this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
        }
        this.ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.defaultReturnValue(0);
        this.ENTITY_TYPE_RENDER_LAYER.defaultReturnValue(0);
    }

    public static ETFManager getInstance() {
        if (manager == null) {
            manager = new ETFManager();
        }
        return manager;
    }

    public static void resetInstance() {
        ETFUtils2.KNOWN_NATIVE_IMAGES = new ETFLruCache();
        ETFClientCommon.etf$loadConfig();
        ETFDirectory.resetCache();
        manager = new ETFManager();
    }

    private static ETFTexture getErrorETFTexture() {
        ETFUtils2.registerNativeImageToIdentifier(ETFUtils2.emptyNativeImage(), new class_2960("etf:error.png"));
        ETFUtils2.logWarn("getErrorETFTexture() was called, investigate this if called too much");
        return new ETFTexture(new class_2960("etf:error.png"), false);
    }

    public static EmissiveRenderModes getEmissiveMode() {
        if (ETFClientCommon.ETFConfigData.emissiveRenderMode == EmissiveRenderModes.DULL) {
            return EmissiveRenderModes.DULL;
        }
        if (ETFClientCommon.ETFConfigData.emissiveRenderMode == EmissiveRenderModes.COMPATIBLE && ETFVersionDifferenceHandler.areShadersInUse()) {
            return EmissiveRenderModes.DULL;
        }
        return EmissiveRenderModes.BRIGHT;
    }

    public void removeThisEntityDataFromAllStorage(ETFCacheKey ETFId) {
        this.ENTITY_TEXTURE_MAP.removeEntryOnly(ETFId);
        UUID uuid = ETFId.getMobUUID();
        this.ENTITY_SPAWN_CONDITIONS_CACHE.removeEntryOnly(uuid);
        this.ENTITY_IS_UPDATABLE.removeBoolean((Object)uuid);
        this.ENTITY_UPDATE_QUEUE.remove((Object)uuid);
        this.ENTITY_DEBUG_QUEUE.remove((Object)uuid);
        this.ENTITY_BLINK_TIME.removeLong((Object)uuid);
        this.UUID_TO_MOB_CACHE_KEY_MAP_FOR_FEATURE_USAGE.remove((Object)uuid);
    }

    public void checkIfShouldTriggerUpdate(UUID id) {
        if (this.ENTITY_IS_UPDATABLE.getBoolean((Object)id) && ETFClientCommon.ETFConfigData.enableCustomTextures && ETFClientCommon.ETFConfigData.textureUpdateFrequency_V2 != ETFConfig.UpdateFrequency.Never) {
            if (this.ENTITY_UPDATE_QUEUE.size() > 2000) {
                this.ENTITY_UPDATE_QUEUE.clear();
            }
            int delay = ETFClientCommon.ETFConfigData.textureUpdateFrequency_V2.getDelay();
            long randomizer = (long)delay * 20L;
            if (System.currentTimeMillis() % randomizer == (long)Math.abs(id.hashCode()) % randomizer) {
                this.ENTITY_UPDATE_QUEUE.add((Object)id);
            }
        }
    }

    public void markEntityForDebugPrint(UUID id) {
        if (ETFClientCommon.ETFConfigData.debugLoggingMode != ETFConfig.DebugLogMode.None) {
            this.ENTITY_DEBUG_QUEUE.add((Object)id);
        }
    }

    @NotNull
    public ETFTexture getETFDefaultTexture(class_2960 vanillaIdentifier, boolean canBePatched) {
        return this.getOrCreateETFTexture(vanillaIdentifier, vanillaIdentifier, canBePatched);
    }

    @NotNull
    public <T extends class_1297> ETFTexture getETFTexture(@NotNull class_2960 vanillaIdentifier, @Nullable T entity, @NotNull TextureSource source, boolean canBePatched) {
        try {
            if (entity == null) {
                return this.getETFDefaultTexture(vanillaIdentifier, canBePatched);
            }
            UUID id = entity.method_5667();
            ETFCacheKey cacheKey = new ETFCacheKey(id, vanillaIdentifier);
            if (source == TextureSource.ENTITY) {
                this.UUID_TO_MOB_CACHE_KEY_MAP_FOR_FEATURE_USAGE.put((Object)id, (Object)cacheKey);
            }
            if (id == ETF_GENERIC_UUID || entity.method_24515().equals((Object)class_2382.field_11176)) {
                return this.getETFDefaultTexture(vanillaIdentifier, canBePatched);
            }
            if (this.ENTITY_TEXTURE_MAP.containsKey(cacheKey)) {
                ETFTexture quickReturn = this.ENTITY_TEXTURE_MAP.get(cacheKey);
                if (quickReturn == null) {
                    ETFTexture vanillaETF = this.getETFDefaultTexture(vanillaIdentifier, canBePatched);
                    this.ENTITY_TEXTURE_MAP.put(cacheKey, vanillaETF);
                    quickReturn = vanillaETF;
                }
                if (source == TextureSource.ENTITY) {
                    if (this.ENTITY_DEBUG_QUEUE.contains((Object)id)) {
                        boolean inChat = ETFClientCommon.ETFConfigData.debugLoggingMode == ETFConfig.DebugLogMode.Chat;
                        ETFUtils2.logMessage("\nGeneral ETF:\n - Texture cache size: " + this.ETF_TEXTURE_CACHE.size() + "\nThis " + entity.method_5864().toString() + ":\n - Texture: " + quickReturn + "\nEntity cache size: " + this.ENTITY_TEXTURE_MAP.size() + "\n - Original spawn state: " + this.ENTITY_SPAWN_CONDITIONS_CACHE.get(id) + "\n - OptiFine property count: " + (this.OPTIFINE_PROPERTY_CACHE.containsKey((Object)vanillaIdentifier) ? ((List)Objects.requireNonNullElse((List)this.OPTIFINE_PROPERTY_CACHE.get((Object)vanillaIdentifier), new ArrayList())).size() : 0) + "\n - Non property random total: " + this.TRUE_RANDOM_COUNT_CACHE.getInt((Object)vanillaIdentifier), inChat);
                        this.ENTITY_DEBUG_QUEUE.remove((Object)id);
                    }
                    if (this.ENTITY_UPDATE_QUEUE.contains((Object)id)) {
                        class_2960 newVariantIdentifier = this.returnNewAlreadyConfirmedOptifineTexture(entity, vanillaIdentifier, true);
                        this.ENTITY_TEXTURE_MAP.put(cacheKey, Objects.requireNonNullElse(this.getOrCreateETFTexture(vanillaIdentifier, Objects.requireNonNullElse(newVariantIdentifier, vanillaIdentifier), canBePatched), this.getETFDefaultTexture(vanillaIdentifier, canBePatched)));
                        if (!quickReturn.thisIdentifier.equals((Object)newVariantIdentifier)) {
                            ObjectOpenHashSet featureSet = (ObjectOpenHashSet)this.ENTITY_KNOWN_FEATURES_LIST.getOrDefault((Object)id, (Object)new ObjectOpenHashSet());
                            featureSet.forEach(forKey -> {
                                class_2960 forVariantIdentifier = this.getPossibleVariantIdentifierRedirectForFeatures(entity, forKey.identifier(), TextureSource.ENTITY_FEATURE);
                                this.ENTITY_TEXTURE_MAP.put((ETFCacheKey)forKey, Objects.requireNonNullElse(this.getOrCreateETFTexture(forKey.identifier(), Objects.requireNonNullElse(forVariantIdentifier, forKey.identifier()), canBePatched), this.getETFDefaultTexture(forKey.identifier(), canBePatched)));
                            });
                        }
                        this.ENTITY_UPDATE_QUEUE.remove((Object)id);
                    } else {
                        this.checkIfShouldTriggerUpdate(id);
                    }
                }
                return quickReturn;
            }
            class_2960 possibleIdentifier = source == TextureSource.ENTITY_FEATURE ? this.getPossibleVariantIdentifierRedirectForFeatures(entity, vanillaIdentifier, source) : this.getPossibleVariantIdentifier(entity, vanillaIdentifier, source);
            ETFTexture foundTexture = Objects.requireNonNullElse(this.getOrCreateETFTexture(vanillaIdentifier, possibleIdentifier == null ? vanillaIdentifier : possibleIdentifier, canBePatched), this.getETFDefaultTexture(vanillaIdentifier, canBePatched));
            this.ENTITY_TEXTURE_MAP.put(cacheKey, foundTexture);
            if (source == TextureSource.ENTITY_FEATURE) {
                ObjectOpenHashSet knownFeatures = (ObjectOpenHashSet)this.ENTITY_KNOWN_FEATURES_LIST.getOrDefault((Object)entity.method_5667(), (Object)new ObjectOpenHashSet());
                knownFeatures.add((Object)cacheKey);
                this.ENTITY_KNOWN_FEATURES_LIST.put((Object)entity.method_5667(), (Object)knownFeatures);
            }
            return foundTexture;
        }
        catch (Exception e) {
            ETFUtils2.logWarn("ETF Texture error! if this happens more than a couple times, then something is wrong");
            return this.getETFDefaultTexture(vanillaIdentifier, canBePatched);
        }
    }

    @Nullable
    private <T extends class_1297> class_2960 getPossibleVariantIdentifierRedirectForFeatures(T entity, class_2960 vanillaIdentifier, TextureSource source) {
        class_2960 regularReturnIdentifier = this.getPossibleVariantIdentifier(entity, vanillaIdentifier, source);
        if (this.OPTIFINE_PROPERTY_CACHE.get((Object)vanillaIdentifier) == null && (regularReturnIdentifier == null || vanillaIdentifier.equals((Object)regularReturnIdentifier))) {
            ETFTexture baseETFTexture;
            ETFCacheKey baseCacheId = (ETFCacheKey)this.UUID_TO_MOB_CACHE_KEY_MAP_FOR_FEATURE_USAGE.get((Object)entity.method_5667());
            if (baseCacheId != null && this.ENTITY_TEXTURE_MAP.containsKey(baseCacheId) && (baseETFTexture = this.ENTITY_TEXTURE_MAP.get(baseCacheId)) != null) {
                return baseETFTexture.getFeatureTexture(vanillaIdentifier);
            }
        } else {
            return regularReturnIdentifier;
        }
        return null;
    }

    @Nullable
    private <T extends class_1297> class_2960 getPossibleVariantIdentifier(T entity, class_2960 vanillaIdentifier, TextureSource source) {
        if (ETFClientCommon.ETFConfigData.enableCustomTextures) {
            if (this.TRUE_RANDOM_COUNT_CACHE.containsKey((Object)vanillaIdentifier) || this.OPTIFINE_PROPERTY_CACHE.containsKey((Object)vanillaIdentifier)) {
                int randomCount;
                List optifineProperties;
                if (this.OPTIFINE_PROPERTY_CACHE.containsKey((Object)vanillaIdentifier) && (optifineProperties = (List)this.OPTIFINE_PROPERTY_CACHE.get((Object)vanillaIdentifier)) != null) {
                    return this.returnNewAlreadyConfirmedOptifineTexture(entity, vanillaIdentifier, false, optifineProperties);
                }
                if (this.TRUE_RANDOM_COUNT_CACHE.containsKey((Object)vanillaIdentifier) && source != TextureSource.ENTITY_FEATURE && (randomCount = this.TRUE_RANDOM_COUNT_CACHE.getInt((Object)vanillaIdentifier)) != this.TRUE_RANDOM_COUNT_CACHE.defaultReturnValue()) {
                    return this.returnNewAlreadyConfirmedTrueRandomTexture(entity, vanillaIdentifier, randomCount);
                }
                return null;
            }
            class_2960 possibleProperty = ETFDirectory.getDirectoryVersionOf(ETFUtils2.replaceIdentifier(vanillaIdentifier, ".png", ".properties"));
            class_2960 possible2PNG = ETFDirectory.getDirectoryVersionOf(ETFUtils2.replaceIdentifier(vanillaIdentifier, ".png", "2.png"));
            if (possible2PNG == null && possibleProperty == null) {
                this.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
                return null;
            }
            if (possibleProperty == null) {
                if (source != TextureSource.ENTITY_FEATURE) {
                    this.newTrueRandomTextureFound(vanillaIdentifier, possible2PNG);
                    return this.returnNewAlreadyConfirmedTrueRandomTexture(entity, vanillaIdentifier);
                }
            } else {
                if (possible2PNG == null) {
                    ETFTexturePropertiesUtils.processNewOptifinePropertiesFile(entity, vanillaIdentifier, possibleProperty);
                    return this.returnNewAlreadyConfirmedOptifineTexture(entity, vanillaIdentifier, false);
                }
                class_3300 resources = class_310.method_1551().method_1478();
                String p2pngPackName = null;
                try {
                    p2pngPackName = resources.method_14486(possible2PNG).method_14480();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String propertiesPackName = null;
                try {
                    propertiesPackName = resources.method_14486(possibleProperty).method_14480();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (propertiesPackName != null && propertiesPackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{p2pngPackName, propertiesPackName}))) {
                    ETFTexturePropertiesUtils.processNewOptifinePropertiesFile(entity, vanillaIdentifier, possibleProperty);
                    return this.returnNewAlreadyConfirmedOptifineTexture(entity, vanillaIdentifier, false);
                }
                if (source != TextureSource.ENTITY_FEATURE) {
                    this.newTrueRandomTextureFound(vanillaIdentifier, possible2PNG);
                    return this.returnNewAlreadyConfirmedTrueRandomTexture(entity, vanillaIdentifier);
                }
            }
        }
        this.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
        return null;
    }

    private void newTrueRandomTextureFound(class_2960 vanillaIdentifier, class_2960 variant2PNG) {
        class_3300 resources = class_310.method_1551().method_1478();
        int totalTextureCount = 2;
        while (ETFUtils2.isExistingResource(ETFUtils2.replaceIdentifier(variant2PNG, "[0-9]+(?=\\.png)", String.valueOf(totalTextureCount + 1)))) {
            ++totalTextureCount;
        }
        this.TRUE_RANDOM_COUNT_CACHE.put((Object)vanillaIdentifier, totalTextureCount);
    }

    @Nullable
    private <T extends class_1297> class_2960 returnNewAlreadyConfirmedOptifineTexture(T entity, class_2960 vanillaIdentifier, boolean isThisAnUpdate) {
        return this.returnNewAlreadyConfirmedOptifineTexture(entity, vanillaIdentifier, isThisAnUpdate, (List)this.OPTIFINE_PROPERTY_CACHE.get((Object)vanillaIdentifier));
    }

    @Nullable
    private <T extends class_1297> class_2960 returnNewAlreadyConfirmedOptifineTexture(T entity, class_2960 vanillaIdentifier, boolean isThisAnUpdate, List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> optifineProperties) {
        int variantNumber = this.testAndGetVariantNumberFromOptiFineCases(entity, isThisAnUpdate, optifineProperties);
        class_2960 variantIdentifier = this.returnNewAlreadyNumberedRandomTexture(vanillaIdentifier, variantNumber);
        if (variantIdentifier == null) {
            return null;
        }
        if (this.ETF_TEXTURE_CACHE.containsKey((Object)variantIdentifier)) {
            if (this.ETF_TEXTURE_CACHE.get((Object)variantIdentifier) == null) {
                return null;
            }
            return variantIdentifier;
        }
        if (ETFUtils2.isExistingResource(variantIdentifier)) {
            return variantIdentifier;
        }
        this.ETF_TEXTURE_CACHE.put((Object)variantIdentifier, null);
        return null;
    }

    private <T extends class_1297> int testAndGetVariantNumberFromOptiFineCases(T entity, boolean isThisAnUpdate, List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> optifineProperties) {
        try {
            for (ETFTexturePropertiesUtils.ETFTexturePropertyCase property : optifineProperties) {
                if (!property.doesEntityMeetConditionsOfThisCase(entity, isThisAnUpdate, this.ENTITY_IS_UPDATABLE)) continue;
                return property.getAnEntityVariantSuffixFromThisCase(entity.method_5667());
            }
        }
        catch (Exception e) {
            return 1;
        }
        return 1;
    }

    @NotNull
    private <T extends class_1297> class_2960 returnNewAlreadyConfirmedTrueRandomTexture(T entity, class_2960 vanillaIdentifier) {
        return this.returnNewAlreadyConfirmedTrueRandomTexture(entity, vanillaIdentifier, this.TRUE_RANDOM_COUNT_CACHE.getInt((Object)vanillaIdentifier));
    }

    @NotNull
    private <T extends class_1297> class_2960 returnNewAlreadyConfirmedTrueRandomTexture(T entity, class_2960 vanillaIdentifier, int totalCount) {
        class_2960 toReturn;
        int randomReliable = Math.abs(entity.method_5667().hashCode());
        randomReliable %= totalCount;
        return (toReturn = this.returnNewAlreadyNumberedRandomTexture(vanillaIdentifier, ++randomReliable)) == null ? vanillaIdentifier : toReturn;
    }

    @Nullable
    private class_2960 returnNewAlreadyNumberedRandomTexture(class_2960 vanillaIdentifier, int variantNumber) {
        return ETFDirectory.getDirectoryVersionOf(ETFUtils2.replaceIdentifier(vanillaIdentifier, ".png", variantNumber + ".png"));
    }

    @NotNull
    private ETFTexture getOrCreateETFTexture(class_2960 vanillaIdentifier, class_2960 variantIdentifier, boolean canBePatched) {
        if (this.ETF_TEXTURE_CACHE.containsKey((Object)variantIdentifier)) {
            ETFTexture cached = (ETFTexture)this.ETF_TEXTURE_CACHE.get((Object)variantIdentifier);
            if (cached != null) {
                return cached;
            }
            ETFUtils2.logWarn("getOrCreateETFTexture found a null, this probably should not be happening");
            cached = (ETFTexture)this.ETF_TEXTURE_CACHE.get((Object)vanillaIdentifier);
            if (cached != null) {
                return cached;
            }
        } else {
            ETFTexture foundTexture = new ETFTexture(variantIdentifier, canBePatched);
            this.ETF_TEXTURE_CACHE.put((Object)variantIdentifier, (Object)foundTexture);
            return foundTexture;
        }
        ETFUtils2.logError("getOrCreateETFTexture and should not have");
        return ETF_ERROR_TEXTURE;
    }

    @Nullable
    public ETFPlayerTexture getPlayerTexture(class_1657 player, class_2960 rendererGivenSkin) {
        try {
            UUID id = player.method_5667();
            if (this.PLAYER_TEXTURE_MAP.containsKey(id)) {
                ETFPlayerTexture possibleSkin = this.PLAYER_TEXTURE_MAP.get(id);
                if (possibleSkin == null || possibleSkin.player == null && possibleSkin.isCorrectObjectForThisSkin(rendererGivenSkin)) {
                    return null;
                }
                if (possibleSkin.isCorrectObjectForThisSkin(rendererGivenSkin) || class_310.method_1551().field_1755 instanceof ETFConfigScreenSkinTool) {
                    return possibleSkin;
                }
            }
            this.PLAYER_TEXTURE_MAP.put(id, null);
            ETFPlayerTexture etfPlayerTexture = new ETFPlayerTexture(player, rendererGivenSkin);
            this.PLAYER_TEXTURE_MAP.put(id, etfPlayerTexture);
            return etfPlayerTexture;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum EmissiveRenderModes {
        DULL,
        BRIGHT,
        COMPATIBLE;


        public static EmissiveRenderModes blockEntityMode() {
            if (ETFClientCommon.ETFConfigData.emissiveRenderMode == DULL) {
                return DULL;
            }
            if (ETFVersionDifferenceHandler.isThisModLoaded("iris")) {
                if (ETFClientCommon.ETFConfigData.emissiveRenderMode == COMPATIBLE && ETFVersionDifferenceHandler.areShadersInUse()) {
                    return DULL;
                }
                return BRIGHT;
            }
            return DULL;
        }

        public String toString() {
            switch (this) {
                case DULL: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_mode.dull").getString();
                }
                case BRIGHT: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_mode.bright").getString();
                }
            }
            return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_mode.compatible").getString();
        }

        public EmissiveRenderModes next() {
            switch (this) {
                case DULL: {
                    return BRIGHT;
                }
                case BRIGHT: {
                    return COMPATIBLE;
                }
            }
            return DULL;
        }
    }

    public static enum TextureSource {
        ENTITY,
        BLOCK_ENTITY,
        ENTITY_FEATURE;

    }
}

