/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.AEWorldGenType;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.class_2960;

@ThreadSafe
public final class AEWorldGen {
    private static final Map<AEWorldGenType, TypeSet> settings = new EnumMap<AEWorldGenType, TypeSet>(AEWorldGenType.class);

    private AEWorldGen() {
    }

    public static synchronized void disableWorldGenForBiome(AEWorldGenType type, class_2960 biomeId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(biomeId);
        AEWorldGen.settings.get((Object)((Object)type)).modBiomeBlacklist.add(biomeId);
    }

    public static synchronized boolean isWorldGenDisabledForBiome(AEWorldGenType type, class_2960 biomeId) {
        TypeSet typeSettings = settings.get((Object)type);
        return typeSettings.configBiomeBlacklist.contains(biomeId) || typeSettings.modBiomeBlacklist.contains(biomeId);
    }

    static synchronized void setConfigBlacklists(List<class_2960> quartzBiomeBlacklist) {
        AEWorldGen.settings.get((Object)((Object)AEWorldGenType.CERTUS_QUARTZ)).configBiomeBlacklist.clear();
        AEWorldGen.settings.get((Object)((Object)AEWorldGenType.CERTUS_QUARTZ)).configBiomeBlacklist.addAll(quartzBiomeBlacklist);
    }

    static {
        for (AEWorldGenType type : AEWorldGenType.values()) {
            settings.put(type, new TypeSet());
        }
    }

    private static class TypeSet {
        final Set<class_2960> modBiomeBlacklist = new HashSet<class_2960>();
        final Set<class_2960> configBiomeBlacklist = new HashSet<class_2960>();

        private TypeSet() {
        }
    }
}

