/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.core.definitions.AEParts;
import appeng.items.parts.PartItem;
import appeng.parts.p2p.P2PTunnelPart;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;

@ThreadSafe
public final class P2PTunnelAttunement {
    private static final int INITIAL_CAPACITY = 40;
    static final Map<class_1792, class_1792> tunnels = new HashMap<class_1792, class_1792>(40);
    static final Map<class_6862<class_1792>, class_1792> tagTunnels = new IdentityHashMap<class_6862<class_1792>, class_1792>(40);
    static final Map<String, class_1792> modIdTunnels = new HashMap<String, class_1792>(40);
    static final List<ApiAttunement<?>> apiAttunements = new ArrayList(40);
    public static final class_1935 ME_TUNNEL = AEParts.ME_P2P_TUNNEL;
    public static final class_1935 ENERGY_TUNNEL = AEParts.FE_P2P_TUNNEL;
    public static final class_1935 REDSTONE_TUNNEL = AEParts.REDSTONE_P2P_TUNNEL;
    public static final class_1935 FLUID_TUNNEL = AEParts.FLUID_P2P_TUNNEL;
    public static final class_1935 ITEM_TUNNEL = AEParts.ITEM_P2P_TUNNEL;
    public static final class_1935 LIGHT_TUNNEL = AEParts.LIGHT_P2P_TUNNEL;

    private P2PTunnelAttunement() {
    }

    public static class_6862<class_1792> getAttunementTag(class_1935 tunnel) {
        Objects.requireNonNull(tunnel.method_8389(), "tunnel.asItem()");
        class_2960 itemKey = class_2378.field_11142.method_10221((Object)tunnel.method_8389());
        if (itemKey.equals((Object)class_2378.field_11142.method_10137())) {
            throw new IllegalArgumentException("Tunnel item must be registered first.");
        }
        return class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(itemKey.method_12836(), "p2p_attunements/" + itemKey.method_12832()));
    }

    public static synchronized void registerAttunementTag(class_1935 tunnel) {
        Objects.requireNonNull(tunnel.method_8389(), "tunnel.asItem()");
        P2PTunnelAttunement.addItemByTag(P2PTunnelAttunement.getAttunementTag(tunnel), tunnel);
    }

    public static synchronized <T> void registerAttunementApi(class_1935 tunnelPart, ItemApiLookup<?, T> api, Function<class_1799, T> contextProvider, class_2561 description) {
        Objects.requireNonNull(api, "api");
        Objects.requireNonNull(contextProvider, "contextProvider");
        apiAttunements.add(new ApiAttunement<T>(api, contextProvider, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart), description));
    }

    public static synchronized void registerAttunementApi(class_1935 tunnelPart, ItemApiLookup<?, ContainerItemContext> api, class_2561 description) {
        P2PTunnelAttunement.registerAttunementApi(tunnelPart, api, stack -> ContainerItemContext.ofSingleSlot((SingleSlotStorage)new SingleStackStorage((class_1799)stack){
            class_1799 buffer;
            final /* synthetic */ class_1799 val$stack;
            {
                this.val$stack = class_17992;
                this.buffer = this.val$stack;
            }

            protected class_1799 getStack() {
                return this.buffer;
            }

            protected void setStack(class_1799 stack) {
                this.buffer = stack;
            }
        }), description);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static synchronized void addItem(class_1935 trigger, class_1935 tunnelPart) {
        Objects.requireNonNull(trigger, "trigger");
        class_1792 triggerItem = trigger.method_8389();
        Objects.requireNonNull(triggerItem, "trigger.asItem()");
        Preconditions.checkArgument((triggerItem != class_1802.field_8162 ? 1 : 0) != 0, (Object)"trigger shouldn't be air!");
        tunnels.put(triggerItem, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static synchronized void addItemByTag(class_6862<class_1792> trigger, class_1935 tunnelPart) {
        Objects.requireNonNull(trigger, "trigger");
        tagTunnels.put(trigger, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static synchronized void addItemByMod(String modId, class_1935 tunnelPart) {
        Objects.requireNonNull(modId, "modId");
        modIdTunnels.put(modId, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static synchronized <T> void addItemByApi(ItemApiLookup<?, T> api, Function<class_1799, T> contextProvider, class_1935 tunnelPart) {
        P2PTunnelAttunement.registerAttunementApi(tunnelPart, api, contextProvider, (class_2561)new class_2585("<missing description>"));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.19")
    public static synchronized void addItemByApi(ItemApiLookup<?, ContainerItemContext> api, class_1935 tunnelPart) {
        P2PTunnelAttunement.registerAttunementApi(tunnelPart, api, (class_2561)new class_2585("<missing description>"));
    }

    public static synchronized class_1799 getTunnelPartByTriggerItem(class_1799 trigger) {
        if (trigger.method_7960()) {
            return class_1799.field_8037;
        }
        class_1792 tunnelItem = tunnels.get(trigger.method_7909());
        if (tunnelItem != null) {
            return new class_1799((class_1935)tunnelItem);
        }
        for (class_6862 class_68622 : trigger.method_40133().toList()) {
            class_1792 tagTunnelItem = tagTunnels.get(class_68622);
            if (tagTunnelItem == null) continue;
            return new class_1799((class_1935)tagTunnelItem);
        }
        for (ApiAttunement apiAttunement : apiAttunements) {
            if (!apiAttunement.hasApi(trigger)) continue;
            return new class_1799((class_1935)apiAttunement.tunnelType());
        }
        for (Map.Entry entry : modIdTunnels.entrySet()) {
            class_2960 id = class_2378.field_11142.method_10221((Object)trigger.method_7909());
            if (!id.method_12836().equals(entry.getKey())) continue;
            return new class_1799((class_1935)entry.getValue());
        }
        return class_1799.field_8037;
    }

    private static class_1792 validateTunnelPartItem(class_1935 itemLike) {
        Objects.requireNonNull(itemLike, "item");
        class_1792 item = itemLike.method_8389();
        Objects.requireNonNull(item, "item");
        if (!(item instanceof PartItem)) {
            throw new IllegalArgumentException("Given tunnel part item is not a part");
        }
        PartItem partItem = (PartItem)item;
        if (!P2PTunnelPart.class.isAssignableFrom(partItem.getPartClass())) {
            throw new IllegalArgumentException("Given tunnel part item results in a part that is not a P2P tunnel: " + partItem);
        }
        return item;
    }

    record ApiAttunement<T>(ItemApiLookup<?, T> api, Function<class_1799, T> contextProvider, class_1792 tunnelType, class_2561 component) {
        public boolean hasApi(class_1799 stack) {
            return this.api.find(stack, this.contextProvider.apply(stack)) != null;
        }
    }
}

