/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.implementations.menuobjects;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class ItemMenuHost
implements IUpgradeableObject {
    private final class_1657 player;
    @Nullable
    private final Integer slot;
    private final class_1799 itemStack;
    private final IUpgradeInventory upgrades;
    private int powerTicks = 0;
    private double powerDrainPerTick = 0.5;

    public ItemMenuHost(class_1657 player, @Nullable Integer slot, class_1799 itemStack) {
        this.player = player;
        this.slot = slot;
        this.itemStack = itemStack;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IUpgradeableItem) {
            IUpgradeableItem upgradeableItem = (IUpgradeableItem)class_17922;
            this.upgrades = upgradeableItem.getUpgrades(itemStack);
        } else {
            this.upgrades = UpgradeInventories.empty();
        }
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    @Nullable
    public Integer getSlot() {
        return this.slot;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public boolean isClientSide() {
        return this.player.field_6002.field_9236;
    }

    public boolean onBroadcastChanges(class_1703 menu) {
        return true;
    }

    protected boolean ensureItemStillInSlot() {
        if (this.slot == null) {
            return true;
        }
        class_1799 expectedItem = this.getItemStack();
        class_1661 inventory = this.getPlayer().method_31548();
        class_1799 currentItem = inventory.method_5438(this.slot.intValue());
        if (!currentItem.method_7960() && !expectedItem.method_7960()) {
            if (currentItem == expectedItem) {
                return true;
            }
            if (class_1799.method_7984((class_1799)expectedItem, (class_1799)currentItem)) {
                inventory.method_5447(this.slot.intValue(), expectedItem);
                return true;
            }
        }
        return false;
    }

    public boolean drainPower() {
        ItemMenuHost itemMenuHost = this;
        if (itemMenuHost instanceof IEnergySource) {
            IEnergySource energySource = (IEnergySource)((Object)itemMenuHost);
            ++this.powerTicks;
            if (this.powerTicks > 10) {
                double amt = (double)this.powerTicks * this.powerDrainPerTick;
                this.powerTicks = 0;
                return energySource.extractAEPower(amt, Actionable.MODULATE, PowerMultiplier.CONFIG) > 0.0;
            }
        }
        return true;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        this.powerDrainPerTick = powerDrainPerTick;
    }

    @Override
    public final IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }
}

