/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.inventories;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.ItemTransfer;
import appeng.util.Platform;
import appeng.util.helpers.ItemComparisonHelper;
import java.util.Iterator;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

class PlatformInventoryWrapper
implements ItemTransfer {
    private final Storage<ItemVariant> storage;

    public PlatformInventoryWrapper(Storage<ItemVariant> storage) {
        this.storage = storage;
    }

    @Override
    public boolean mayAllowTransfer() {
        return this.storage.supportsInsertion() || this.storage.supportsExtraction();
    }

    @Override
    public class_1799 removeItems(int amount, class_1799 filter, Predicate<class_1799> destination) {
        class_1799 result;
        try (Transaction tx = Platform.openOrJoinTx();){
            result = this.innerRemoveItems(amount, filter, destination, tx);
            tx.commit();
        }
        return result;
    }

    @Override
    public class_1799 simulateRemove(int amount, class_1799 filter, Predicate<class_1799> destination) {
        class_1799 result;
        try (Transaction tx = Platform.openOrJoinTx();){
            result = this.innerRemoveItems(amount, filter, destination, tx);
        }
        return result;
    }

    private class_1799 innerRemoveItems(int amount, class_1799 filter, Predicate<class_1799> destination, Transaction tx) {
        ItemVariant rv = ItemVariant.blank();
        long extractedAmount = 0L;
        Iterator it = this.storage.iterator((TransactionContext)tx);
        while (it.hasNext() && extractedAmount < (long)amount) {
            StorageView view = (StorageView)it.next();
            ItemVariant is = (ItemVariant)view.getResource();
            if (is.isBlank()) continue;
            if (rv.isBlank()) {
                long actualAmount;
                if (!filter.method_7960() && !is.matches(filter) || destination != null && !destination.test(is.toStack()) || (actualAmount = view.extract((Object)is, (long)amount - extractedAmount, (TransactionContext)tx)) <= 0L) continue;
                rv = is;
                extractedAmount += actualAmount;
                continue;
            }
            if (!rv.equals(is)) continue;
            extractedAmount += view.extract((Object)is, (long)amount, (TransactionContext)tx);
        }
        if (extractedAmount > (long)amount) {
            // empty if block
        }
        return rv.toStack((int)Math.min((long)amount, extractedAmount));
    }

    @Override
    public class_1799 removeSimilarItems(int amount, class_1799 filter, FuzzyMode fuzzyMode, Predicate<class_1799> destination) {
        class_1799 result;
        try (Transaction tx = Platform.openOrJoinTx();){
            result = this.innerRemoveSimilarItems(amount, filter, fuzzyMode, destination, tx);
            tx.commit();
        }
        return result;
    }

    @Override
    public class_1799 simulateSimilarRemove(int amount, class_1799 filter, FuzzyMode fuzzyMode, Predicate<class_1799> destination) {
        class_1799 result;
        try (Transaction tx = Platform.openOrJoinTx();){
            result = this.innerRemoveSimilarItems(amount, filter, fuzzyMode, destination, tx);
        }
        return result;
    }

    private class_1799 innerRemoveSimilarItems(int amount, class_1799 filter, FuzzyMode fuzzyMode, Predicate<class_1799> destination, Transaction tx) {
        for (StorageView view : this.storage.iterable((TransactionContext)tx)) {
            long actualAmount;
            ItemVariant is = (ItemVariant)view.getResource();
            if (is.isBlank() || !filter.method_7960() && !ItemComparisonHelper.isFuzzyEqualItem(is.toStack(), filter, fuzzyMode) || destination != null && !destination.test(is.toStack()) || (actualAmount = view.extract((Object)is, (long)amount, (TransactionContext)tx)) <= 0L) continue;
            if (actualAmount > (long)amount) {
                actualAmount = amount;
            }
            return is.toStack((int)actualAmount);
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 addItems(class_1799 itemsToAdd, boolean simulate) {
        if (itemsToAdd.method_7960()) {
            return class_1799.field_8037;
        }
        try (Transaction tx = Platform.openOrJoinTx();){
            class_1799 remainder = itemsToAdd.method_7972();
            long inserted = this.storage.insert((Object)ItemVariant.of((class_1799)itemsToAdd), (long)itemsToAdd.method_7947(), (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            remainder.method_7934((int)inserted);
            class_1799 class_17992 = remainder.method_7960() ? class_1799.field_8037 : remainder;
            return class_17992;
        }
    }
}

