/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.DeferredBlockEntityUnloader;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.helpers.ICustomNameObject;
import appeng.hooks.VisualStateSaving;
import appeng.hooks.ticking.TickHandler;
import appeng.items.tools.MemoryCardItem;
import appeng.util.CustomNameUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.helpers.ItemComparisonHelper;
import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class AEBaseBlockEntity
extends class_2586
implements IOrientable,
ICustomNameObject,
ISegmentedInventory,
RenderAttachmentBlockEntity {
    private static final Map<class_2591<?>, class_1792> REPRESENTATIVE_ITEMS;
    @Nullable
    private String customName;
    private class_2350 forward = class_2350.field_11043;
    private class_2350 up = class_2350.field_11036;
    private boolean setChangedQueued = false;
    private byte queuedForReady = 0;
    private byte readyInvoked = 0;

    protected void onChunkUnloaded() {
    }

    public AEBaseBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    public static void registerBlockEntityItem(class_2591<?> type, class_1792 wat) {
        REPRESENTATIVE_ITEMS.put(type, wat);
    }

    public boolean notLoaded() {
        return !this.field_11863.method_22340(this.field_11867);
    }

    public class_2586 getBlockEntity() {
        return this;
    }

    protected class_1792 getItemFromBlockEntity() {
        return REPRESENTATIVE_ITEMS.getOrDefault(this.method_11017(), class_1802.field_8162);
    }

    public final void method_11014(class_2487 tag) {
        if (tag.method_10573("#upd", 7) && tag.method_10546() == 1) {
            byte[] updateData = tag.method_10547("#upd");
            if (this.readUpdateData(new class_2540(Unpooled.wrappedBuffer((byte[])updateData))) && this.field_11863 != null) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
            }
            return;
        }
        if (tag.method_10573("visual", 10)) {
            this.loadVisualState(tag.method_10562("visual"));
        }
        super.method_11014(tag);
        this.loadTag(tag);
    }

    public void loadTag(class_2487 data) {
        this.customName = data.method_10545("customName") ? data.method_10558("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = class_2350.valueOf((String)data.method_10558("forward").toUpperCase(Locale.ROOT));
                this.up = class_2350.valueOf((String)data.method_10558("up").toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void method_11007(class_2487 data) {
        if (VisualStateSaving.isEnabled(this.field_11863)) {
            class_2487 visualTag = new class_2487();
            this.saveVisualState(visualTag);
            data.method_10566("visual", (class_2520)visualTag);
        }
        super.method_11007(data);
        if (this.canBeRotated()) {
            data.method_10582("forward", this.getForward().name());
            data.method_10582("up", this.getUp().name());
        }
        if (this.customName != null) {
            data.method_10582("customName", this.customName);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void onReady() {
        this.readyInvoked = (byte)(this.readyInvoked + 1);
    }

    protected void scheduleInit() {
        this.queuedForReady = (byte)(this.queuedForReady + 1);
        GridHelper.onFirstTick(this, AEBaseBlockEntity::onReady);
    }

    public class_2487 method_16887() {
        class_2487 data = new class_2487();
        class_2540 stream = new class_2540(Unpooled.buffer());
        this.writeToStream(stream);
        stream.capacity(stream.readableBytes());
        data.method_10570("#upd", stream.array());
        return data;
    }

    private boolean readUpdateData(class_2540 stream) {
        boolean output = false;
        try {
            output = this.readFromStream(stream);
        }
        catch (Throwable t) {
            AELog.warn(t);
        }
        return output;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected boolean readFromStream(class_2540 data) {
        if (this.canBeRotated()) {
            class_2350 old_Forward = this.forward;
            class_2350 old_Up = this.up;
            byte orientation = data.readByte();
            this.forward = class_2350.values()[orientation & 7];
            this.up = class_2350.values()[orientation >> 3];
            return this.forward != old_Forward || this.up != old_Up;
        }
        return false;
    }

    protected void writeToStream(class_2540 data) {
        if (this.canBeRotated()) {
            byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
            data.writeByte((int)orientation);
        }
    }

    @MustBeInvokedByOverriders
    protected void saveVisualState(class_2487 data) {
    }

    @MustBeInvokedByOverriders
    protected void loadVisualState(class_2487 data) {
    }

    public void markForUpdate() {
        if (this.field_11863 != null && !this.method_11015() && !this.notLoaded()) {
            AEBaseEntityBlock block;
            class_2680 newState;
            boolean alreadyUpdated = false;
            class_2680 currentState = this.method_11010();
            class_2248 class_22482 = currentState.method_26204();
            if (class_22482 instanceof AEBaseEntityBlock && currentState != (newState = (block = (AEBaseEntityBlock)class_22482).getBlockEntityBlockState(currentState, this))) {
                AELog.blockUpdate(this.field_11867, currentState, newState, this);
                this.field_11863.method_8501(this.field_11867, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.field_11863.method_8413(this.field_11867, currentState, currentState, 1);
            }
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public class_2350 getForward() {
        return this.forward;
    }

    @Override
    public class_2350 getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
        this.saveChanges();
    }

    @OverridingMethodsMustInvokeSuper
    public void exportSettings(SettingsFrom mode, class_2487 output, @Nullable class_1657 player) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            MemoryCardItem.exportGenericSettings(this, output);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        class_2561 customName = CustomNameUtil.getCustomName(input);
        if (customName != null) {
            this.customName = customName.getString();
        }
        MemoryCardItem.importGenericSettings(this, input, player);
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
    }

    @Override
    public class_2561 getCustomInventoryName() {
        return new class_2585(this.hasCustomInventoryName() ? this.customName : this.getClass().getSimpleName());
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void securityBreak() {
        this.field_11863.method_22352(this.field_11867, true);
    }

    public boolean isClientSide() {
        class_1937 level = this.method_10997();
        return level == null || level.method_8608();
    }

    public void saveChanges() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.method_5431();
        } else {
            this.field_11863.method_8524(this.field_11867);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private Object setChangedAtEndOfTick(class_1937 level) {
        this.method_5431();
        this.setChangedQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public InternalInventory getSubInventory(class_2960 id) {
        return null;
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return new AEModelData(this.up, this.forward);
    }

    public class_1269 disassembleWithWrench(class_1657 player, class_1937 level, class_3965 hitResult) {
        class_2338 pos = hitResult.method_17777();
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        Object[] itemDropCandidates = Platform.getBlockDrops(level, pos);
        class_1799 op = new class_1799((class_1935)this.method_11010().method_26204());
        for (class_1799 class_17992 : itemDropCandidates) {
            if (!ItemComparisonHelper.isEqualItemType(class_17992, op)) continue;
            class_2487 tag = new class_2487();
            this.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
            if (tag.method_33133()) continue;
            class_17992.method_7980(tag);
        }
        block.method_9576(level, pos, blockState, player);
        level.method_8650(pos, false);
        block.method_9585((class_1936)level, pos, this.method_11010());
        ArrayList itemsToDrop = Lists.newArrayList((Object[])itemDropCandidates);
        Platform.spawnDrops(level, pos, itemsToDrop);
        return class_1269.method_29236((boolean)level.method_8608());
    }

    public class_1269 rotateWithWrench(class_1657 player, class_1937 level, class_3965 hitResult) {
        AEBaseBlock aeBlock;
        class_2338 pos = hitResult.method_17777();
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof AEBaseBlock && (aeBlock = (AEBaseBlock)block).rotateAroundFaceAxis((class_1936)level, pos, hitResult.method_17780())) {
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public byte getQueuedForReady() {
        return this.queuedForReady;
    }

    public byte getReadyInvoked() {
        return this.readyInvoked;
    }

    static {
        DeferredBlockEntityUnloader.register();
        REPRESENTATIVE_ITEMS = new HashMap();
    }
}

