/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PatternProviderBlockEntity
extends AENetworkBlockEntity
implements PatternProviderLogicHost {
    private final PatternProviderLogic logic = new PatternProviderLogic(this.getMainNode(), this);
    private boolean omniDirectional = true;

    public PatternProviderBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
    }

    public void setSide(class_2350 facing) {
        Object newForward = !this.omniDirectional && this.getForward() == facing.method_10153() ? facing : (!this.omniDirectional && (this.getForward() == facing || this.getForward() == facing.method_10153()) ? null : (this.omniDirectional ? facing.method_10153() : Platform.rotateAround(this.getForward(), facing)));
        this.setPushDirection((class_2350)newForward);
    }

    public void setPushDirection(@javax.annotation.Nullable class_2350 direction) {
        boolean bl = this.omniDirectional = direction == null;
        if (direction == null) {
            direction = class_2350.field_11043;
        }
        class_2350 newUp = class_2350.field_11036;
        if (direction == class_2350.field_11036 || direction == class_2350.field_11033) {
            newUp = class_2350.field_11043;
        }
        this.setOrientation(direction, newUp);
        if (!this.isClientSide()) {
            this.configureNodeSides();
            this.markForUpdate();
            this.saveChanges();
        }
    }

    private void configureNodeSides() {
        if (this.omniDirectional) {
            this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
        } else {
            this.getMainNode().setExposedOnSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        }
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        this.logic.addDrops(drops);
    }

    @Override
    public void onReady() {
        this.configureNodeSides();
        super.onReady();
        this.logic.updatePatterns();
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10556("omniDirectional", this.omniDirectional);
        this.logic.writeToNBT(data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.omniDirectional = data.method_10577("omniDirectional");
        this.logic.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean oldOmniDirectional = this.omniDirectional;
        this.omniDirectional = data.readBoolean();
        return oldOmniDirectional != this.omniDirectional || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.omniDirectional);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<class_2350> getTargets() {
        if (this.omniDirectional) {
            return EnumSet.allOf(class_2350.class);
        }
        return EnumSet.of(this.getForward());
    }

    @Override
    public void exportSettings(SettingsFrom mode, class_2487 output, @Nullable class_1657 player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
        }
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.importSettings(input, player);
        }
    }

    public boolean isOmniDirectional() {
        return this.omniDirectional;
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return AEBlocks.PATTERN_PROVIDER.stack();
    }
}

