/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.ConfigInventory;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class CellWorkbenchBlockEntity
extends AEBaseBlockEntity
implements IConfigurableObject,
IUpgradeableObject,
InternalInventoryHost,
IConfigInvHost {
    private final AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    private final GenericStackInv config = new GenericStackInv(this::configChanged, GenericStackInv.Mode.CONFIG_TYPES, 63);
    private final ConfigManager manager = new ConfigManager(this::saveChanges);
    private IUpgradeInventory cacheUpgrades = null;
    private ConfigInventory cacheConfig = null;
    private boolean locked = false;

    public CellWorkbenchBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.manager.registerSetting(Settings.COPY_MODE, CopyMode.CLEAR_ON_REMOVE);
        this.cell.setEnableClientEvents(true);
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getStackInSlot(0).method_7960()) {
            return null;
        }
        if (this.cell.getStackInSlot(0).method_7909() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getStackInSlot(0).method_7909();
        }
        return null;
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.cell.writeToNBT(data, "cell");
        this.config.writeToChildTag(data, "config");
        this.manager.writeToNBT(data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.cell.readFromNBT(data, "cell");
        this.config.readFromChildTag(data, "config");
        this.manager.readFromNBT(data);
    }

    @Override
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.CELLS)) {
            return this.cell;
        }
        return super.getSubInventory(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            try {
                this.cacheUpgrades = null;
                this.cacheConfig = null;
                ConfigInventory configInventory = this.getCellConfigInventory();
                if (configInventory != null) {
                    if (!configInventory.isEmpty()) {
                        CellWorkbenchBlockEntity.copy(configInventory, this.config);
                    } else {
                        CellWorkbenchBlockEntity.copy(this.config, configInventory);
                        CellWorkbenchBlockEntity.copy(configInventory, this.config);
                    }
                } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                    this.config.clear();
                    this.saveChanges();
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    private void configChanged() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        try {
            ConfigInventory c = this.getCellConfigInventory();
            if (c != null) {
                CellWorkbenchBlockEntity.copy(this.config, c);
                CellWorkbenchBlockEntity.copy(c, this.config);
            }
        }
        finally {
            this.locked = false;
        }
    }

    public static void copy(GenericStackInv from, GenericStackInv to) {
        int i;
        for (i = 0; i < Math.min(from.size(), to.size()); ++i) {
            to.setStack(i, from.getStack(i));
        }
        for (i = from.size(); i < to.size(); ++i) {
            to.setStack(i, null);
        }
    }

    private ConfigInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            class_1799 is = this.cell.getStackInSlot(0);
            if (is.method_7960()) {
                return null;
            }
            ConfigInventory inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        if (!this.cell.getStackInSlot(0).method_7960()) {
            drops.add(this.cell.getStackInSlot(0));
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public GenericStackInv getConfig() {
        return this.config;
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return UpgradeInventories.empty();
            }
            class_1799 is = this.cell.getStackInSlot(0);
            if (is.method_7960()) {
                return UpgradeInventories.empty();
            }
            IUpgradeInventory inv = cell.getUpgrades(is);
            if (inv == null) {
                return UpgradeInventories.empty();
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }
}

