/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class VibrationChamberBlockEntity
extends AENetworkInvBlockEntity
implements IGridTickable {
    public static final double POWER_PER_TICK = 5.0;
    public static final int MIN_BURN_SPEED = 20;
    public static final int MAX_BURN_SPEED = 200;
    public static final double DILATION_SCALING = 25.0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private final InternalInventory invExt = new FilteredInternalInventory(this.inv, new FuelSlotFilter());
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public VibrationChamberBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).setFlags(new GridFlags[0]).addService(IGridTickable.class, this);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("burnTime", this.getBurnTime());
        data.method_10549("maxBurnTime", this.getMaxBurnTime());
        data.method_10569("burnSpeed", this.getBurnSpeed());
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.setBurnTime(data.method_10574("burnTime"));
        this.setMaxBurnTime(data.method_10574("maxBurnTime"));
        this.setBurnSpeed(data.method_10550("burnSpeed"));
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        return this.invExt;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
    }

    private boolean canEatFuel() {
        int newBurnTime;
        class_1799 is = this.inv.getStackInSlot(0);
        return !is.method_7960() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.method_7947() > 0;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber, this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 25.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        IGrid grid = node.getGrid();
        IEnergyService energy = grid.getEnergyService();
        double newPower = timePassed * 5.0;
        double overFlow = energy.injectPower(newPower, Actionable.SIMULATE);
        energy.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
        if (overFlow > 0.0) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
        } else {
            this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
    }

    private void eatFuel() {
        int newBurnTime;
        class_1799 is = this.inv.getStackInSlot(0);
        if (!is.method_7960() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.method_7947() > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime);
            this.setMaxBurnTime(this.getBurnTime());
            class_1792 fuelItem = is.method_7909();
            is.method_7934(1);
            if (is.method_7960()) {
                this.inv.setItemDirect(0, new class_1799((class_1935)fuelItem.method_7858()));
            } else {
                this.inv.setItemDirect(0, is);
            }
            this.saveChanges();
        }
        if (this.getBurnTime() > 0.0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.method_11002()) {
                Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
            }
        }
    }

    public static int getBurnTime(class_1799 is) {
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)is.method_7909());
        return burnTime != null ? burnTime : 0;
    }

    public static boolean hasBurnTime(class_1799 is) {
        return VibrationChamberBlockEntity.getBurnTime(is) > 0;
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }

    private static class FuelSlotFilter
    implements IAEItemFilter {
        private FuelSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return !VibrationChamberBlockEntity.hasBurnTime(inv.getStackInSlot(slot));
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return VibrationChamberBlockEntity.hasBurnTime(stack);
        }
    }
}

